/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.tramplestopper;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="tramplestopper", dependencies="required:forge@[14.23.4.2725,);", acceptedMinecraftVersions="[1.12.2]")
public class TrampleStopper {
    public static final String MOD_ID = "tramplestopper";
    private static Logger logger;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onFarmlandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
        switch (TrampleConfig.type) {
            case FEATHER_FALLING: {
                Iterable armorInventoryList = event.getEntity().func_184193_aE();
                for (ItemStack itemStack : armorInventoryList) {
                    if (!(itemStack.func_77973_b() instanceof ItemArmor)) continue;
                    ItemArmor amourItem = (ItemArmor)itemStack.func_77973_b();
                    if (amourItem.field_77881_a != EntityEquipmentSlot.FEET || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)itemStack) < TrampleConfig.neededLevel) continue;
                    event.setCanceled(true);
                    TrampleStopper.getLogger().debug("Canceled FarmlandTrampleEvent");
                }
                break;
            }
            case NEVER: {
                event.setCanceled(true);
                TrampleStopper.getLogger().debug("Canceled FarmlandTrampleEvent");
                break;
            }
            case ALWAYS: {
                event.setCanceled(false);
                break;
            }
        }
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getLogger((String)MOD_ID);
        }
        return logger;
    }

    public static enum Type {
        NEVER,
        ALWAYS,
        FEATHER_FALLING,
        DEFAULT;

    }

    @Config(modid="tramplestopper")
    public static class TrampleConfig {
        @Config.Comment(value={"When should farmland get trampled", "Never: Never trampled farmland", "Always: It Always get trampled", "Default: Normal behavior", "Feather Falling: Does not get trampled with you have feather falling boots"})
        public static Type type = Type.FEATHER_FALLING;
        @Config.Comment(value={"Level of Feather Falling needed"})
        public static int neededLevel = 1;
    }
}

