/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror.stream;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.shadowfacts.mirror.MirrorMethod;

public class MethodStream
implements Stream<MirrorMethod> {
    private Stream<MirrorMethod> underlying;

    public MethodStream(Stream<MirrorMethod> underlying) {
        this.underlying = underlying;
    }

    public Stream<Method> unwrap() {
        return this.map((Function)MirrorMethod::unwrap);
    }

    public MethodStream filterDeclaringClass(Class<?> ... classes) {
        return this.filter((T m) -> {
            Class<?> declaringClass = m.declaringClass().unwrap();
            for (Class c : classes) {
                if (declaringClass != c) continue;
                return true;
            }
            return false;
        });
    }

    public Stream<Object> invoke(Object instance, Object ... args) {
        return this.map((Function)m -> m.invoke(instance, args));
    }

    public Object[] invokeToArray(Object instance, Object ... args) {
        return this.invoke(instance, args).toArray();
    }

    public MethodStream hasAnnotation(Class<? extends Annotation> clazz) {
        return this.filter((T m) -> m.hasAnnotation(clazz));
    }

    public <A extends Annotation> Stream<A> getAnnotation(Class<A> clazz) {
        return this.map((Function)m -> m.getAnnotation(clazz));
    }

    public MethodStream isStatic() {
        return this.filter(MirrorMethod::isStatic);
    }

    public MethodStream isNotStatic() {
        return this.filter(MirrorMethod::isNotStatic);
    }

    public MethodStream isAbstract() {
        return this.filter(MirrorMethod::isAbstract);
    }

    public MethodStream isNotAbstract() {
        return this.filter(MirrorMethod::isNotAbstract);
    }

    public MethodStream isPublic() {
        return this.filter(MirrorMethod::isPublic);
    }

    public MethodStream isProtected() {
        return this.filter(MirrorMethod::isProtected);
    }

    public MethodStream isPrivate() {
        return this.filter(MirrorMethod::isPrivate);
    }

    public MethodStream hasModifier(int modifier) {
        return this.filter((T f) -> f.hasModifier(modifier));
    }

    public MethodStream setAccessible(boolean accessible) {
        return this.peek((T f) -> f.setAccessible(accessible));
    }

    public MethodStream filter(Predicate<? super MirrorMethod> predicate) {
        return new MethodStream(this.underlying.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super MirrorMethod, ? extends R> mapper) {
        return this.underlying.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super MirrorMethod> mapper) {
        return this.underlying.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super MirrorMethod> mapper) {
        return this.underlying.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super MirrorMethod> mapper) {
        return this.underlying.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super MirrorMethod, ? extends Stream<? extends R>> mapper) {
        return this.underlying.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super MirrorMethod, ? extends IntStream> mapper) {
        return this.underlying.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super MirrorMethod, ? extends LongStream> mapper) {
        return this.underlying.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super MirrorMethod, ? extends DoubleStream> mapper) {
        return this.underlying.flatMapToDouble(mapper);
    }

    public MethodStream distinct() {
        return new MethodStream(this.underlying.distinct());
    }

    public MethodStream sorted() {
        return new MethodStream(this.underlying.sorted());
    }

    public MethodStream sorted(Comparator<? super MirrorMethod> comparator) {
        return new MethodStream(this.underlying.sorted(comparator));
    }

    public MethodStream peek(Consumer<? super MirrorMethod> action) {
        return new MethodStream(this.underlying.peek(action));
    }

    public MethodStream limit(long maxSize) {
        return new MethodStream(this.underlying.limit(maxSize));
    }

    public MethodStream skip(long n) {
        return new MethodStream(this.underlying.skip(n));
    }

    @Override
    public void forEach(Consumer<? super MirrorMethod> action) {
        this.underlying.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super MirrorMethod> action) {
        this.underlying.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.underlying.toArray(generator);
    }

    @Override
    public MirrorMethod reduce(MirrorMethod identity, BinaryOperator<MirrorMethod> accumulator) {
        return this.underlying.reduce(identity, accumulator);
    }

    @Override
    public Optional<MirrorMethod> reduce(BinaryOperator<MirrorMethod> accumulator) {
        return this.underlying.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super MirrorMethod, U> accumulator, BinaryOperator<U> combiner) {
        return this.underlying.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super MirrorMethod> accumulator, BiConsumer<R, R> combiner) {
        return this.underlying.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super MirrorMethod, A, R> collector) {
        return this.underlying.collect(collector);
    }

    @Override
    public Optional<MirrorMethod> min(Comparator<? super MirrorMethod> comparator) {
        return this.underlying.min(comparator);
    }

    @Override
    public Optional<MirrorMethod> max(Comparator<? super MirrorMethod> comparator) {
        return this.underlying.max(comparator);
    }

    @Override
    public long count() {
        return this.underlying.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super MirrorMethod> predicate) {
        return this.underlying.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super MirrorMethod> predicate) {
        return this.underlying.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super MirrorMethod> predicate) {
        return this.underlying.noneMatch(predicate);
    }

    @Override
    public Optional<MirrorMethod> findFirst() {
        return this.underlying.findFirst();
    }

    @Override
    public Optional<MirrorMethod> findAny() {
        return this.underlying.findAny();
    }

    @Override
    public Iterator<MirrorMethod> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public Spliterator<MirrorMethod> spliterator() {
        return this.underlying.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.underlying.isParallel();
    }

    @Override
    public MethodStream sequential() {
        return new MethodStream((Stream)this.underlying.sequential());
    }

    @Override
    public MethodStream parallel() {
        return new MethodStream((Stream)this.underlying.parallel());
    }

    @Override
    public MethodStream unordered() {
        return new MethodStream((Stream)this.underlying.unordered());
    }

    @Override
    public Stream<MirrorMethod> onClose(Runnable closeHandler) {
        this.underlying.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.underlying.close();
    }
}

