/*
 * Decompiled with CFR 0.152.
 */
package jackyy.integrationforegoing.util;

import com.buuz135.industrial.api.IndustrialForegoingHelper;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import jackyy.integrationforegoing.util.EnumIntegrations;
import jackyy.integrationforegoing.util.Reference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ModUtils {
    public static Item getItemByName(String modid, String name) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, name));
    }

    public static ItemStack getItemStackByName(String modid, String name, int amount, int meta) {
        return new ItemStack(ModUtils.getItemByName(modid, name), amount, meta);
    }

    public static Block getBlockByName(String modid, String name) {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modid, name));
    }

    public static void logIntegration(int state, EnumIntegrations type, String modid) {
        if (state == 0) {
            switch (type) {
                case STRAW: {
                    Reference.LOGGER.info("Registering drink handlers for " + ModUtils.getModNameByID(modid) + "...");
                    break;
                }
                case PLANT: {
                    Reference.LOGGER.info("Registering Plant Gatherer entries for " + ModUtils.getModNameByID(modid) + "...");
                    break;
                }
                case LASERDRILL: {
                    Reference.LOGGER.info("Registering Laser Drill entries for " + ModUtils.getModNameByID(modid) + "...");
                    break;
                }
                case BIOREACTOR: {
                    Reference.LOGGER.info("Registering Bioreactor entries for " + ModUtils.getModNameByID(modid) + "...");
                    break;
                }
                case PROTEIN: {
                    Reference.LOGGER.info("Registering Protein Reactor entries for " + ModUtils.getModNameByID(modid) + "...");
                }
            }
        } else if (state == 1) {
            switch (type) {
                case STRAW: {
                    Reference.LOGGER.info("Registered drink handlers for " + ModUtils.getModNameByID(modid));
                    break;
                }
                case PLANT: {
                    Reference.LOGGER.info("Registered Plant Gatherer entries for " + ModUtils.getModNameByID(modid));
                    break;
                }
                case LASERDRILL: {
                    Reference.LOGGER.info("Registered Laser Drill entries for " + ModUtils.getModNameByID(modid));
                    break;
                }
                case BIOREACTOR: {
                    Reference.LOGGER.info("Registered Bioreactor entries for " + ModUtils.getModNameByID(modid));
                    break;
                }
                case PROTEIN: {
                    Reference.LOGGER.info("Registered Protein Reactor entries for " + ModUtils.getModNameByID(modid));
                }
            }
        }
    }

    public static String getModNameByID(String modid) {
        Map indexedModList = Loader.instance().getIndexedModList();
        ModContainer modContainer = (ModContainer)indexedModList.get(modid);
        if (modContainer != null) {
            return modContainer.getName();
        }
        return modid;
    }

    public static void registerBioReactorEntry(String modid, String name, int amount, int meta) {
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name)) != null) {
            IndustrialForegoingHelper.addBioReactorEntry((BioReactorEntry)new BioReactorEntry(ModUtils.getItemStackByName(modid, name, amount, meta)));
        }
    }

    public static void registerProteinReactorEntry(String modid, String name, int amount, int meta) {
        if (ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name)) != null) {
            IndustrialForegoingHelper.addProteinReactorEntry((ProteinReactorEntry)new ProteinReactorEntry(ModUtils.getItemStackByName(modid, name, amount, meta)));
        }
    }

    public static void loadLaserDrillFile(String fileName) {
        LaserDrillEntry.addOreFile((ResourceLocation)new ResourceLocation("integrationforegoing", fileName + "_ores.json"));
    }

    public static void deleteExistingLaserDrillFile(File dir, String fileName) {
        Path path = dir.toPath().resolve("laser_drill_ores");
        if (Files.exists(path, new LinkOption[0])) {
            File file = new File(path.toFile(), fileName + "_ores.json");
            if (!file.exists()) {
                return;
            }
            if (file.delete()) {
                Reference.LOGGER.info("Deleted existing Laser Drill config file " + file.getName());
            }
        }
    }
}

