/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class BlockPosTools {
    public static final BlockPos INVALID = new BlockPos(-1, -1, -1);

    public static boolean isAdjacent(BlockPos c1, BlockPos c2) {
        int dz;
        int dy;
        int dx = Math.abs(c2.func_177958_n() - c1.func_177958_n()) + 1;
        return dx * (dy = Math.abs(c2.func_177956_o() - c1.func_177956_o()) + 1) * (dz = Math.abs(c2.func_177952_p() - c1.func_177952_p()) + 1) == 2;
    }

    public static int area(BlockPos c1, BlockPos c2) {
        return (c2.func_177958_n() - c1.func_177958_n() + 1) * (c2.func_177956_o() - c1.func_177956_o() + 1) * (c2.func_177952_p() - c1.func_177952_p() + 1);
    }

    public static BlockPos center(BlockPos c1, BlockPos c2) {
        return new BlockPos((c1.func_177958_n() + c2.func_177958_n()) / 2, (c1.func_177956_o() + c2.func_177956_o()) / 2, (c1.func_177952_p() + c2.func_177952_p()) / 2);
    }

    public static BlockPos readFromNBT(NBTTagCompound tagCompound, String tagName) {
        int[] array = tagCompound.func_74759_k(tagName);
        if (array.length == 0) {
            return null;
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static void writeToNBT(NBTTagCompound tagCompound, String tagName, BlockPos coordinate) {
        if (coordinate == null) {
            tagCompound.func_74783_a(tagName, new int[0]);
        } else {
            tagCompound.func_74783_a(tagName, new int[]{coordinate.func_177958_n(), coordinate.func_177956_o(), coordinate.func_177952_p()});
        }
    }

    public static NBTTagCompound writeToNBT(BlockPos coordinate) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        BlockPosTools.writeToNBT(tagCompound, "c", coordinate);
        return tagCompound;
    }

    public static String toString(BlockPos pos) {
        return pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p();
    }

    public static ChunkPos getChunkCoordFromPos(BlockPos pos) {
        return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }
}

