/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.helpers;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class NbtHelpers {
    public static NBTTagCompound getNbtCompound(ItemStack stack) {
        return stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
    }

    public static boolean keyExists(ItemStack stack, String key) {
        return stack.func_77978_p() == null ? false : stack.func_77978_p().func_74764_b(key);
    }

    public static int getInt(ItemStack stack, String key) {
        return NbtHelpers.getInt(stack, key, 0);
    }

    public static int getInt(ItemStack stack, String key, int defaultValue) {
        if (!NbtHelpers.keyExists(stack, key)) {
            return defaultValue;
        }
        return NbtHelpers.getNbtCompound(stack).func_74762_e(key);
    }

    public static ItemStack setInt(ItemStack stack, String key, int value) {
        NBTTagCompound tag = NbtHelpers.getNbtCompound(stack);
        tag.func_74768_a(key, value);
        stack.func_77982_d(tag);
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultValue) {
        if (!NbtHelpers.keyExists(stack, key)) {
            return defaultValue;
        }
        return NbtHelpers.getNbtCompound(stack).func_74767_n(key);
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NbtHelpers.getNbtCompound(stack).func_74757_a(key, value);
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String key) {
        if (!NbtHelpers.keyExists(stack, key)) {
            return null;
        }
        return NbtHelpers.getNbtCompound(stack).func_74775_l(key);
    }

    public static NBTBase getTag(ItemStack stack, String key) {
        if (!NbtHelpers.keyExists(stack, key)) {
            return null;
        }
        return NbtHelpers.getNbtCompound(stack).func_74781_a(key);
    }

    public static void setTag(ItemStack stack, String key, NBTBase value) {
        NbtHelpers.getNbtCompound(stack).func_74782_a(key, value);
    }

    public static long getLong(ItemStack stack, String key) {
        return NbtHelpers.getLong(stack, key, 0L);
    }

    public static long getLong(ItemStack stack, String key, long defaultValue) {
        if (!NbtHelpers.keyExists(stack, key)) {
            return defaultValue;
        }
        return NbtHelpers.getNbtCompound(stack).func_74763_f(key);
    }

    public static ItemStack setLong(ItemStack stack, String key, long value) {
        NBTTagCompound tag = NbtHelpers.getNbtCompound(stack);
        tag.func_74772_a(key, value);
        stack.func_77982_d(tag);
        return stack;
    }

    public static ItemStack deleteKey(ItemStack stack, String key) {
        NBTTagCompound tag = NbtHelpers.getNbtCompound(stack);
        tag.func_82580_o(key);
        return stack;
    }
}

