/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.swing;

import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.minecraft.util.StringUtils;

public class UIAddModBranch
extends JFrame
implements ActionListener {
    private TreeBranchRoot parentBranch;
    private JPanel contentPane;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel textPane;
    private JLabel idLabel;
    private JTextField idField;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel selectLabel;
    private JComboBox selectorBox;
    private JButton createButton;

    public UIAddModBranch(TreeBranchRoot branch) {
        this.parentBranch = branch;
        this.setupUI();
        this.setTitle("Add Mod");
        this.setDefaultCloseOperation(2);
        this.createButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.selectorBox.addActionListener(this);
    }

    private void setupUI() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1));
        this.contentPane.setMaximumSize(new Dimension(600, 145));
        this.contentPane.setMinimumSize(new Dimension(600, 145));
        this.contentPane.setPreferredSize(new Dimension(600, 145));
        this.textPane = new JPanel();
        this.textPane.setLayout(new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.textPane.setDoubleBuffered(true);
        this.textPane.setOpaque(true);
        this.textPane.setVisible(true);
        this.contentPane.add((Component)this.textPane, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 1, null, null, null, 0, false));
        this.textPane.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, new Color(-4473925)));
        this.idLabel = new JLabel();
        this.idLabel.setText("Mod ID (Lowercase)");
        this.textPane.add((Component)this.idLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.idField = new JTextField();
        this.textPane.add((Component)this.idField, new GridConstraints(1, 0, 1, 2, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        Spacer spacer1 = new Spacer();
        this.textPane.add((Component)spacer1, new GridConstraints(4, 0, 1, 3, 0, 2, 1, 4, null, null, null, 0, false));
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Mod Name");
        this.textPane.add((Component)this.nameLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.nameField = new JTextField();
        this.textPane.add((Component)this.nameField, new GridConstraints(3, 0, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.selectLabel = new JLabel();
        this.selectLabel.setText("Select From Installed");
        this.textPane.add((Component)this.selectLabel, new GridConstraints(0, 1, 1, 2, 4, 0, 0, 0, null, null, null, 0, false));
        this.selectorBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        this.selectorBox.setMaximumRowCount(20);
        for (String modid : ModHelper.getLoadedMods().keySet()) {
            defaultComboBoxModel1.addElement(modid);
        }
        this.selectorBox.setModel(defaultComboBoxModel1);
        this.textPane.add((Component)this.selectorBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.textPane.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)this.buttonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.buttonPanel.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.createButton = new JButton();
        this.createButton.setText("Create");
        this.buttonPanel.add((Component)this.createButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.buttonPanel.add((Component)this.cancelButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.contentPane.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.setContentPane(this.contentPane);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("comboBoxChanged")) {
            String selected = this.selectorBox.getSelectedItem().toString();
            this.idField.setText(selected.toLowerCase());
            this.nameField.setText(ModHelper.getLoadedMods().get(selected));
        }
        if (command.equals("Create")) {
            if (WikiDocManager.modDocMap.containsKey(this.idField.getText())) {
                JOptionPane.showMessageDialog(this, "There is already documentation for that mod! Just add to the existing documentation.", "Error", 0);
            } else if (StringUtils.func_151246_b((String)this.idField.getText()) || StringUtils.func_151246_b((String)this.nameField.getText())) {
                JOptionPane.showMessageDialog(this, "Please fill in both the id and name fields", "Error", 0);
            } else {
                try {
                    WikiDocManager.createNewModEntry(this.idField.getText(), this.nameField.getText(), "en_US");
                    this.dispose();
                }
                catch (Exception e1) {
                    LogHelper.error("####################################################################################################################################################################################");
                    LogHelper.error("Looks like something went wrong! Error: [" + e1.getMessage() + "]");
                    LogHelper.error("");
                    e1.printStackTrace();
                    LogHelper.error("");
                    LogHelper.error("####################################################################################################################################################################################");
                    String trace = "";
                    int lines = 0;
                    for (StackTraceElement o : e1.getStackTrace()) {
                        trace = trace + ((Object)o).toString() + "\n";
                        if (++lines <= 5) continue;
                        trace = trace + "....";
                        break;
                    }
                    JOptionPane.showMessageDialog(this, "An exception occurred when creating the mod xml.\n\nMessage:\n" + e1.getMessage() + "\n\nTrace: (" + e1.getClass().getName() + ")\n" + trace, "Error", 0);
                }
            }
        }
        if (command.equals("Cancel")) {
            this.dispose();
        }
    }
}

