/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.um.api.modifier;

import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import com.valkyrieofnight.um.api.modifier.IModifier;
import com.valkyrieofnight.um.api.modifier.ModifierID;
import java.util.List;
import javax.annotation.Nonnull;

public interface IModifierHandler {
    public boolean hasModifier(ModifierID var1);

    default public boolean hasModifier(@Nonnull IModifier modifier) {
        return this.hasModifier(modifier.getModifierID());
    }

    default public boolean addModifier(IModifier modifier, int total) {
        return this.setModifier(modifier, this.getTotal(modifier) + total);
    }

    default public boolean addModifier(@Nonnull IModifier modifier) {
        return this.addModifier(modifier, 1);
    }

    public boolean setModifier(IModifier var1, int var2);

    default public void setModifiers(List<IModifier> modifiers) {
        this.removeModifiersAll();
        for (IModifier iModifier : modifiers) {
            this.addModifier(iModifier);
        }
    }

    public void removeModifier(@Nonnull ModifierID var1);

    public void removeModifiersAll();

    public int getTotal(ModifierID var1);

    default public int getTotal(@Nonnull IModifier modifier) {
        return this.getTotal(modifier.getModifierID());
    }

    public boolean hasAttribute(AttributeID var1);

    public List<IAttribute> getAttributes(AttributeID var1);

    public Object getAttributeFinalValue(AttributeID var1);

    default public AttributeCache getAttributeCache(AttributeID attributeID) {
        return new AttributeCache(attributeID, this.getAttributeFinalValue(attributeID));
    }
}

