/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.m_guide.json.objects;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.valkyrieofnight.vlib.core.io.json.IJsonSerializer;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.VLElementItemStackList;
import com.valkyrieofnight.vliblegacy.lib.client.gui.elements.container.VLEleContBase;
import com.valkyrieofnight.vliblegacy.lib.json.JsonUtils;
import com.valkyrieofnight.vliblegacy.m_guide.json.objects.GuideObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class GOItemStack
extends GuideObject {
    public static final GOItemStack BLANK = new GOItemStack();
    public List<String> items = new ArrayList<String>();
    public boolean drawToolTip = false;
    public int ticksPerItem = 20;

    @Override
    public String getType() {
        return "itemstack";
    }

    public String toString() {
        String str = "{" + this.items + "}";
        return str;
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String is : this.items) {
            ItemStack stack = JsonUtils.getFromString(is);
            if (stack == ItemStack.field_190927_a) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    public void initElement(String baseAddress, VLEleContBase cont) {
        VLElementItemStackList isl = new VLElementItemStackList(baseAddress + "." + cont.getTotalElements() + this.getType(), 0, 0, this.getStacks());
        cont.addElement(isl);
    }

    public static class GOItemStackSerializer
    implements IJsonSerializer<GOItemStack> {
        public GOItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonElement tk;
            JsonElement tt;
            GOItemStack r = new GOItemStack();
            JsonObject jobj = json.getAsJsonObject();
            JsonElement id = jobj.get("items");
            if (id != null) {
                r.items = (List)context.deserialize(id, List.class);
            }
            if ((tt = jobj.get("tooltip")) != null) {
                r.drawToolTip = tt.getAsBoolean();
            }
            if ((tk = jobj.get("ticks")) != null) {
                r.ticksPerItem = tk.getAsInt();
            }
            return r;
        }

        public JsonElement serialize(GOItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject r = new JsonObject();
            r.addProperty("type", src.getType());
            r.add("items", context.serialize(src.items, List.class));
            r.addProperty("tooltip", Boolean.valueOf(src.drawToolTip));
            r.addProperty("ticks", (Number)src.ticksPerItem);
            return r;
        }
    }
}

