/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.text.translation.I18n;

public class Lang {
    @Nonnull
    private static final String REGEX = "\\|";
    public static final char CHAR = '|';
    @Nonnull
    private final String prefix;

    public Lang(@Nonnull String locKey) {
        this.prefix = locKey.concat(".");
    }

    @Nonnull
    public String getPrefix() {
        return this.prefix;
    }

    @Nonnull
    public String addPrefix(@Nonnull String suffix) {
        return this.prefix.concat(suffix);
    }

    @Nonnull
    public String localize(@Nonnull String unloc, Object ... args) {
        return this.localizeExact(this.addPrefix(unloc), args);
    }

    @Nonnull
    public String localize(@Nonnull String unloc) {
        return this.localizeExact(this.addPrefix(unloc));
    }

    @Nonnull
    public String localizeExact(@Nonnull String unloc, Object ... args) {
        return I18n.func_74837_a((String)unloc, (Object[])args);
    }

    @Nonnull
    public String localizeExact(@Nonnull String unloc) {
        return I18n.func_74838_a((String)unloc);
    }

    @Nonnull
    public String[] localizeList(@Nonnull String unloc, String ... args) {
        return this.splitList(this.localize(unloc, args));
    }

    @Nonnull
    public String[] localizeList(@Nonnull String unloc) {
        return this.splitList(this.localize(unloc));
    }

    @Nonnull
    public List<String> localizeAll(@Nonnull List<String> unloc) {
        ArrayList ret = Lists.newArrayList();
        for (String s : unloc) {
            String notnulliswear = s;
            ret.add(this.localize(notnulliswear == null ? "null" : notnulliswear));
        }
        return ret;
    }

    @Nonnull
    public String[] localizeAll(@Nonnull Lang lang, String ... unloc) {
        String[] ret = new String[unloc.length];
        for (int i = 0; i < ret.length; ++i) {
            String notnulliswear = unloc[i];
            ret[i] = lang.localize(notnulliswear == null ? "null" : notnulliswear);
        }
        return ret;
    }

    @Nonnull
    public String[] splitList(@Nonnull String list) {
        return list.split(REGEX);
    }

    public boolean canLocalize(@Nonnull String unloc) {
        return this.canLocalizeExact(this.addPrefix(unloc));
    }

    public boolean canLocalizeExact(@Nonnull String unloc) {
        return I18n.func_94522_b((String)unloc);
    }
}

