/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.registry;

import erogenousbeef.bigreactors.api.data.FluidToReactantMapping;
import erogenousbeef.bigreactors.api.data.OreDictToReactantMapping;
import erogenousbeef.bigreactors.api.data.ReactantData;
import erogenousbeef.bigreactors.api.data.SourceProductMapping;
import it.zerono.mods.zerocore.util.ItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;

public class Reactants {
    public static final int standardSolidReactantAmount = 1000;
    public static final int standardFluidReactantAmount = 1;
    private static Map<String, ReactantData> _reactants = new HashMap<String, ReactantData>();
    private static Map<String, OreDictToReactantMapping> _solidToReactant = new HashMap<String, OreDictToReactantMapping>();
    private static Map<String, FluidToReactantMapping> _fluidToReactant = new HashMap<String, FluidToReactantMapping>();
    private static Map<String, List<SourceProductMapping>> _reactantToSolid = new HashMap<String, List<SourceProductMapping>>();
    private static Map<String, List<SourceProductMapping>> _reactantToFluid = new HashMap<String, List<SourceProductMapping>>();

    public static void registerReactant(String name, int type, int color) {
        if (type < 0 || type >= ReactantData.TYPES.length) {
            throw new IllegalArgumentException("Unsupported type; value may only be 0 or 1");
        }
        if (_reactants.containsKey(name)) {
            FMLLog.warning((String)"Overwriting data for reactant %s - someone may be altering BR game data or have duplicate reactant names!", (Object[])new Object[]{name});
        }
        ReactantData data = new ReactantData(name, ReactantData.TYPES[type], color);
        _reactants.put(name, data);
    }

    public static SourceProductMapping registerSolid(ItemStack itemStack, String reactantName) {
        return Reactants.registerSolid(itemStack, reactantName, 1000);
    }

    public static SourceProductMapping registerSolid(ItemStack itemStack, String reactantName, int reactantQty) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        String[] oreDictNames = Reactants.zcGetOreNames(itemStack);
        OreDictToReactantMapping firstMapping = null;
        if (null == oreDictNames) {
            FMLLog.warning((String)"Reactants.registerSolid: Could not resolve ore dict name for %s", (Object[])new Object[]{itemStack.func_77977_a()});
            return null;
        }
        for (String name : oreDictNames) {
            OreDictToReactantMapping mapping = new OreDictToReactantMapping(name, reactantName, reactantQty);
            SourceProductMapping reverseMapping = mapping.getReverse();
            _solidToReactant.put(mapping.getSource(), mapping);
            Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
            if (firstMapping != null) continue;
            firstMapping = mapping;
        }
        return firstMapping;
    }

    public static SourceProductMapping registerSolid(String oreDictName, String reactantName, int reactantAmount) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        OreDictToReactantMapping mapping = new OreDictToReactantMapping(oreDictName, reactantName, reactantAmount);
        _solidToReactant.put(mapping.getSource(), mapping);
        SourceProductMapping reverseMapping = mapping.getReverse();
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
        return mapping;
    }

    public static SourceProductMapping registerSolid(String oreDictName, String reactantName) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        OreDictToReactantMapping mapping = new OreDictToReactantMapping(oreDictName, reactantName);
        SourceProductMapping reverseMapping = mapping.getReverse();
        _solidToReactant.put(mapping.getSource(), mapping);
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
        return mapping;
    }

    public static void registerFluid(FluidStack fluidStack, String reactantName) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        FluidToReactantMapping mapping = new FluidToReactantMapping(fluidStack, reactantName);
        SourceProductMapping reverseMapping = mapping.getReverse();
        _fluidToReactant.put(mapping.getSource(), mapping);
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToFluid);
    }

    public static void registerFluid(Fluid fluid, String reactantName) {
        if (null == fluid) {
            FMLLog.info((String)"TEMP - Skipping registration of NULL fluid for reactant %s", (Object[])new Object[]{reactantName});
            return;
        }
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        FluidToReactantMapping mapping = new FluidToReactantMapping(fluid, reactantName);
        SourceProductMapping reverseMapping = mapping.getReverse();
        _fluidToReactant.put(mapping.getSource(), mapping);
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToFluid);
    }

    public static boolean isKnown(String reactantName) {
        return _reactants.containsKey(reactantName);
    }

    public static ReactantData getReactant(String name) {
        return _reactants.get(name);
    }

    public static OreDictToReactantMapping getSolidToReactant(ItemStack stack) {
        int oreCount;
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIDs == null || (oreCount = oreIDs.length) < 1) {
            return null;
        }
        for (int i = 0; i < oreCount; ++i) {
            String oreDictName = OreDictionary.getOreName((int)oreIDs[i]);
            OreDictToReactantMapping mapping = _solidToReactant.get(oreDictName);
            if (null == mapping) continue;
            return mapping;
        }
        return null;
    }

    public static FluidToReactantMapping getFluidToReactant(FluidStack fluid) {
        return _fluidToReactant.get(fluid.getFluid().getName());
    }

    public static FluidToReactantMapping getFluidToReactant(Fluid fluid) {
        return _fluidToReactant.get(fluid.getName());
    }

    public static List<SourceProductMapping> getReactantToSolids(String reactant) {
        return _reactantToSolid.get(reactant);
    }

    public static List<SourceProductMapping> getFluidsForReactant(String reactant) {
        return _reactantToFluid.get(reactant);
    }

    public static boolean isFuel(ItemStack stack) {
        return ItemHelper.stackIsValid((ItemStack)stack) && Reactants.isFuel(Reactants.getReactantName(stack));
    }

    public static String getReactantName(ItemStack stack) {
        OreDictToReactantMapping mapping = Reactants.getSolidToReactant(stack);
        return mapping != null ? mapping.getProduct() : null;
    }

    public static boolean isFuel(String name) {
        if (name == null) {
            return false;
        }
        ReactantData data = Reactants.getReactant(name);
        return data != null && data.isFuel();
    }

    public static boolean isWaste(ItemStack stack) {
        return ItemHelper.stackIsValid((ItemStack)stack) && Reactants.isWaste(Reactants.getReactantName(stack));
    }

    public static boolean isWaste(String name) {
        if (name == null) {
            return false;
        }
        ReactantData data = Reactants.getReactant(name);
        return data != null && data.isWaste();
    }

    public static int getMinimumReactantToProduceSolid(String reactantName) {
        List<SourceProductMapping> mappings = Reactants.getReactantToSolids(reactantName);
        if (mappings == null || mappings.size() <= 0) {
            throw new IllegalArgumentException("No solid products mapped for reactant " + reactantName);
        }
        int minimumAmount = Integer.MAX_VALUE;
        for (SourceProductMapping mapping : mappings) {
            if (mapping.getSourceAmount() >= minimumAmount) continue;
            minimumAmount = mapping.getSourceAmount();
        }
        return minimumAmount;
    }

    private static void mapReactant(String reactantName, SourceProductMapping mapping, Map<String, List<SourceProductMapping>> map) {
        List<Object> list = null;
        if (!map.containsKey(reactantName) || map.get(reactantName) == null) {
            list = new ArrayList();
            map.put(reactantName, list);
        } else {
            list = map.get(reactantName);
            list.add(mapping);
        }
        list.add(mapping);
    }

    private static String[] zcGetOreNames(ItemStack stack) {
        int count;
        if (ItemHelper.stackIsEmpty((ItemStack)stack)) {
            return null;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIDs == null || (count = oreIDs.length) < 1) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = OreDictionary.getOreName((int)oreIDs[i]);
        }
        return names;
    }
}

