/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.registry;

import erogenousbeef.bigreactors.api.data.CoilPartData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;

public class TurbineCoil {
    private static Map<String, CoilPartData> _blocks = new HashMap<String, CoilPartData>();

    public static void registerBlock(String oreDictName, float efficiency, float bonus, float extractionRate) {
        if (null == oreDictName || oreDictName.isEmpty()) {
            FMLLog.warning((String)"Blocked an attempt to register a new block in the turbine's inductor coil", (Object[])new Object[0]);
            return;
        }
        if (_blocks.containsKey(oreDictName)) {
            CoilPartData data = _blocks.get(oreDictName);
            FMLLog.warning((String)"Overriding existing coil part data for oredict name <%s>, original values: eff %.2f / bonus %.2f, new values: eff %.2f / bonus %.2f", (Object[])new Object[]{oreDictName, Float.valueOf(data.efficiency), Float.valueOf(data.bonus), Float.valueOf(efficiency), Float.valueOf(bonus)});
            data.efficiency = efficiency;
            data.bonus = bonus;
        } else {
            _blocks.put(oreDictName, new CoilPartData(efficiency, bonus, extractionRate));
        }
    }

    @Nullable
    public static CoilPartData deregisterBlock(String oreDictName) {
        return null != oreDictName && !oreDictName.isEmpty() ? _blocks.remove(oreDictName) : null;
    }

    @Nullable
    public static CoilPartData getBlockData(String oreDictName) {
        return _blocks.get(oreDictName);
    }
}

