/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTieredPart;
import erogenousbeef.bigreactors.common.multiblock.block.FuelRodState;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.lib.crafting.RecipeHelper;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockReactorFuelRod
extends BlockTieredPart {
    public BlockReactorFuelRod(String blockName) {
        super(PartType.ReactorFuelRod, blockName, Material.field_151573_f);
        this.func_149715_a(0.9f);
        this.func_149713_g(1);
    }

    public void onRegisterRecipes(@Nonnull IForgeRegistry<IRecipe> registry) {
        if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
            RecipeHelper.addShapedOreDictRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"ICI", "IUI", "ICI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotGraphite", Character.valueOf('U'), BigReactors.CONFIG.recipeYelloriumIngotName});
        }
        if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
            RecipeHelper.addShapedOreDictRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"ICI", "IUI", "ICI", Character.valueOf('I'), "ingotSteel", Character.valueOf('C'), "ingotGraphite", Character.valueOf('U'), BigReactors.CONFIG.recipeYelloriumIngotName});
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityReactorFuelRod();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (BigReactors.CONFIG.disableReactorParticles) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityReactorFuelRod) {
            TileEntityReactorFuelRod fuelRod = (TileEntityReactorFuelRod)te;
            MultiblockReactor reactor = fuelRod.getReactorController();
            if (!fuelRod.isOccluded() && reactor != null && !reactor.isInteriorInvisible() && reactor.getActive() && reactor.getFuelConsumedLastTick() > 0.0f) {
                WorldHelper.spawnVanillaParticles((World)world, (EnumParticleTypes)(BigReactors.VALENTINES_DAY ? EnumParticleTypes.HEART : EnumParticleTypes.CRIT), (int)1, (int)(random.nextInt(4) + 1), (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), (int)1, (int)1, (int)1);
            }
        }
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.FUELRODSTATE});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.FUELRODSTATE, (Comparable)((Object)FuelRodState.Disassembled));
    }

    @Override
    protected IBlockState buildActualState(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part) {
        state = super.buildActualState(state, world, position, part);
        if (part instanceof TileEntityReactorFuelRod) {
            boolean assembled = part.isConnected() && part.getMultiblockController().isAssembled();
            TileEntityReactorFuelRod fuelRod = (TileEntityReactorFuelRod)part;
            FuelRodState rodState = FuelRodState.Disassembled;
            if (assembled) {
                switch (fuelRod.getReactorController().getFuelRodsLayout().getAxis()) {
                    case X: {
                        rodState = FuelRodState.AssembledEW;
                        break;
                    }
                    case Y: {
                        rodState = FuelRodState.AssembledUD;
                        break;
                    }
                    case Z: {
                        rodState = FuelRodState.AssembledSN;
                    }
                }
            }
            state = state.func_177226_a(Properties.FUELRODSTATE, (Comparable)((Object)rodState));
        }
        return state;
    }
}

