/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.editor;

import com.feed_the_beast.ftbquests.gui.editor.EditorFrame;
import com.feed_the_beast.ftbquests.gui.editor.IntVerifier;
import com.feed_the_beast.ftbquests.gui.editor.LootCrateDialog;
import com.feed_the_beast.ftbquests.gui.editor.Tab;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectDirect;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import java.awt.GridLayout;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LootCrateTab
extends Tab {
    public LootCrateTab(EditorFrame e) {
        super(e);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel dropPanel = new JPanel(new GridLayout(0, 4, 6, 6));
        dropPanel.setBorder(BorderFactory.createTitledBorder("Loot Crate Drops"));
        dropPanel.add(LootCrateTab.labelWithTooltip("Crate", "Crate name"));
        dropPanel.add(LootCrateTab.labelWithTooltip("Passive", "Drop weight from passive entities"));
        dropPanel.add(LootCrateTab.labelWithTooltip("Monster", "Drop weight from monsters"));
        dropPanel.add(LootCrateTab.labelWithTooltip("Boss", "Drop weight from bosses"));
        dropPanel.add(LootCrateTab.labelWithTooltip("No Drop", "Weight for no crate dropping"));
        dropPanel.add(LootCrateTab.textField(this.editor.file.lootCrateNoDrop.passive, IntVerifier.NON_NEGATIVE, s -> {
            this.editor.file.lootCrateNoDrop.passive = Integer.parseInt(s);
            new MessageEditObjectDirect(this.editor.file).sendToServer();
        }));
        dropPanel.add(LootCrateTab.textField(this.editor.file.lootCrateNoDrop.monster, IntVerifier.NON_NEGATIVE, s -> {
            this.editor.file.lootCrateNoDrop.monster = Integer.parseInt(s);
            new MessageEditObjectDirect(this.editor.file).sendToServer();
        }));
        dropPanel.add(LootCrateTab.textField(this.editor.file.lootCrateNoDrop.boss, IntVerifier.NON_NEGATIVE, s -> {
            this.editor.file.lootCrateNoDrop.boss = Integer.parseInt(s);
            new MessageEditObjectDirect(this.editor.file).sendToServer();
        }));
        for (RewardTable table : this.editor.file.rewardTables) {
            if (table.lootCrate == null) continue;
            JButton button = new JButton(table.getDisplayName().func_150260_c());
            button.setToolTipText(table.lootCrate.stringID + " | " + table.getCodeString());
            button.addActionListener(e1 -> new LootCrateDialog(this.editor, table.lootCrate).setVisible(true));
            dropPanel.add(button);
            dropPanel.add(LootCrateTab.textField(table.lootCrate.drops.passive, IntVerifier.NON_NEGATIVE, s -> {
                table.lootCrate.drops.passive = Integer.parseInt(s);
                EditorFrame.scheduleObjectEdit(table);
            }));
            dropPanel.add(LootCrateTab.textField(table.lootCrate.drops.monster, IntVerifier.NON_NEGATIVE, s -> {
                table.lootCrate.drops.monster = Integer.parseInt(s);
                EditorFrame.scheduleObjectEdit(table);
            }));
            dropPanel.add(LootCrateTab.textField(table.lootCrate.drops.boss, IntVerifier.NON_NEGATIVE, s -> {
                table.lootCrate.drops.boss = Integer.parseInt(s);
                EditorFrame.scheduleObjectEdit(table);
            }));
        }
        mainPanel.add(dropPanel);
        this.add(mainPanel);
    }

    public static JLabel labelWithTooltip(String label, String tooltip) {
        JLabel l = new JLabel(label);
        l.setHorizontalAlignment(0);
        l.setToolTipText(tooltip);
        return l;
    }

    public static JTextField textField(Object text, final Predicate<String> verifier, Consumer<String> callback) {
        final JTextField textField = new JTextField();
        textField.setHorizontalAlignment(11);
        textField.setText(String.valueOf(text));
        textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return verifier.test(textField.getText());
            }
        });
        EditorFrame.addChangeListener(textField, event -> {
            String txt = textField.getText();
            if (verifier.test(txt)) {
                callback.accept(txt);
            }
        });
        return textField;
    }
}

