/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.editor;

import com.feed_the_beast.ftbquests.gui.editor.EditorFrame;
import com.feed_the_beast.ftbquests.gui.editor.IconTreeCellRenderer;
import com.feed_the_beast.ftbquests.gui.editor.Tab;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import java.awt.GridLayout;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ObjectListTab<T extends QuestObjectBase>
extends Tab
implements TreeSelectionListener {
    public final Class<T> objectClass;
    public final JTree tree;
    public final JPanel panel;
    public T selected = null;

    public ObjectListTab(EditorFrame e, Class<T> o, String title, Icon icon) {
        super(e);
        this.objectClass = o;
        this.setLayout(new GridLayout(0, 1));
        DefaultTreeCellRenderer rootInfo = new DefaultTreeCellRenderer();
        rootInfo.setText(title);
        rootInfo.setIcon(icon);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootInfo);
        this.addElements(root);
        this.tree = new JTree(root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(IconTreeCellRenderer.INSTANCE);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.panel = new JPanel();
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(new JScrollPane(this.tree));
        splitPane.setRightComponent(new JScrollPane(this.panel));
        this.add(splitPane);
    }

    @Override
    public boolean scrollPage() {
        return false;
    }

    public void addElements(DefaultMutableTreeNode root) {
    }

    public void onSelected() {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object o = ((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject();
        this.select(o != null && this.objectClass.isAssignableFrom(o.getClass()) ? (QuestObjectBase)o : null);
    }

    public void select(@Nullable T c) {
        if (this.selected != c) {
            this.selected = c;
            this.panel.removeAll();
            this.onSelected();
            this.panel.revalidate();
            this.panel.repaint();
        }
    }
}

