/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateTaskAt;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class ButtonDummyQuest
extends Widget {
    public GuiQuestTree treeGui;
    public final byte x;
    public final byte y;

    public ButtonDummyQuest(Panel panel, byte _x, byte _y) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.setSize(20, 20);
        this.x = _x;
        this.y = _y;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.questLeft.isMouseOver() || this.treeGui.questRight.isMouseOver() || this.treeGui.subscribe.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public boolean mousePressed(MouseButton button) {
        if (!this.isMouseOver()) {
            return false;
        }
        if (button.isRight() && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (QuestTaskType type : QuestTaskType.getRegistry()) {
                contextMenu.add(new ContextMenuItem(type.getDisplayName().func_150254_d(), type.getIcon(), () -> {
                    GuiHelper.playClickSound();
                    type.getGuiProvider().openCreationGui((IOpenableGui)this, new Quest(this.treeGui.selectedChapter), task -> new MessageCreateTaskAt(this.treeGui.selectedChapter, this.x, this.y, (QuestTask)task).sendToServer());
                }));
            }
            this.getGui().openContextMenu(contextMenu);
            return true;
        }
        if (button.isLeft() && this.treeGui.movingQuest && this.treeGui.getSelectedQuest() != null && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            new MessageMoveQuest(this.treeGui.getSelectedQuest().id, this.x, this.y).sendToServer();
            this.treeGui.movingQuest = false;
            this.treeGui.selectQuest(null);
            return true;
        }
        this.treeGui.selectQuest(null);
        return false;
    }

    public void addMouseOverText(List<String> list) {
        if (this.treeGui.movingQuest && this.treeGui.getSelectedQuest() != null) {
            list.add(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]));
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        if (!this.treeGui.file.canEdit()) {
            return;
        }
        double s = this.treeGui.zoomd * 3.0 / 2.0;
        double sx = (double)x + ((double)w - s) / 2.0;
        double sy = (double)y + ((double)h - s) / 2.0;
        if (this.treeGui.getSelectedQuest() != null && this.treeGui.movingQuest) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
            GlStateManager.func_179139_a((double)s, (double)s, (double)1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            this.treeGui.getSelectedQuest().shape.shape.draw(0, 0, 1, 1, Color4I.WHITE.withAlpha(20));
            GlStateManager.func_179121_F();
        }
        if (this.isMouseOver()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)s, (double)s, (double)1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            Color4I.WHITE.withAlpha(30).draw(0, 0, 1, 1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179139_a((double)(this.treeGui.zoomd / 24.0), (double)(this.treeGui.zoomd / 24.0), (double)1.0);
            theme.drawString("X" + this.x, 2, 2);
            theme.drawString("Y" + this.y, 2, 12);
            GlStateManager.func_179121_F();
        }
    }
}

