/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectDirect;
import com.feed_the_beast.ftbquests.quest.Dependency;
import com.feed_the_beast.ftbquests.quest.EnumDependencyType;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ButtonQuest
extends Button {
    public static final Color4I COL_COMPLETED = Color4I.rgb((int)0x56FF56);
    public static final Color4I COL_STARTED = Color4I.rgb((int)65535);
    public GuiQuestTree treeGui;
    public Quest quest;
    public String description;
    public List<ButtonQuest> dependencies = null;

    public ButtonQuest(Panel panel, Quest q) {
        super(panel, q.getDisplayName().func_150254_d(), q.getIcon());
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.setSize(20, 20);
        this.quest = q;
        this.description = TextFormatting.GRAY + StringUtils.addFormatting((String)this.quest.description);
        if (StringUtils.unformatted((String)this.description).isEmpty()) {
            this.description = "";
        }
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.questLeft.isMouseOver() || this.treeGui.questRight.isMouseOver() || this.treeGui.subscribe.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public List<ButtonQuest> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ButtonQuest>();
            for (Dependency dependency : this.quest.dependencies) {
                if (dependency.isInvalid() || !(dependency.object instanceof Quest) || dependency.type == EnumDependencyType.NOT_REQUIRED) continue;
                for (Widget widget : this.treeGui.quests.widgets) {
                    if (!(widget instanceof ButtonQuest) || dependency.object != ((ButtonQuest)widget).quest) continue;
                    this.dependencies.add((ButtonQuest)widget);
                }
            }
            this.dependencies = this.dependencies.isEmpty() ? Collections.emptyList() : this.dependencies;
        }
        return this.dependencies;
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        Quest selectedQuest = this.treeGui.getSelectedQuest();
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (this.treeGui.selectedQuests.size() > 1) {
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.add_reward_all", (Object[])new Object[0]), FTBQuestsTheme.ADD, () -> {
                    ArrayList<ContextMenuItem> contextMenu2 = new ArrayList<ContextMenuItem>();
                    for (QuestRewardType type : QuestRewardType.getRegistry()) {
                        contextMenu2.add(new ContextMenuItem(type.getDisplayName().func_150254_d(), type.getIcon(), () -> {
                            GuiHelper.playClickSound();
                            type.getGuiProvider().openCreationGui((IOpenableGui)this, this.quest, reward -> {
                                for (Quest quest1 : this.treeGui.selectedQuests) {
                                    QuestReward r = type.provider.create(quest1);
                                    NBTTagCompound nbt1 = new NBTTagCompound();
                                    reward.writeData(nbt1);
                                    r.readData(nbt1);
                                    NBTTagCompound extra = new NBTTagCompound();
                                    extra.func_74778_a("type", type.getTypeForNBT());
                                    new MessageCreateObject(r, extra).sendToServer();
                                }
                            });
                        }));
                    }
                    this.getGui().openContextMenu(contextMenu2);
                }));
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> {
                    this.treeGui.selectedQuests.forEach(q -> ClientQuestFile.INSTANCE.deleteObject(q.id));
                    this.treeGui.selectQuest(null);
                }).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{I18n.func_135052_a((String)"ftbquests.quests", (Object[])new Object[0]) + " [" + this.treeGui.selectedQuests.size() + "]"})));
            } else {
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), GuiIcons.UP, () -> {
                    this.treeGui.movingQuest = true;
                    this.treeGui.selectQuest(this.quest);
                }));
                if (selectedQuest != null && selectedQuest != this.quest) {
                    if (selectedQuest.hasDependency(this.quest)) {
                        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.rem_dep", (Object[])new Object[0]), GuiIcons.REMOVE, () -> this.editDependency(selectedQuest, this.quest, false)));
                    } else if (this.quest.hasDependency(selectedQuest)) {
                        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.rem_dep", (Object[])new Object[0]), GuiIcons.REMOVE, () -> this.editDependency(this.quest, selectedQuest, false)));
                    } else {
                        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.set_dep", (Object[])new Object[0]), FTBQuestsTheme.ADD, () -> this.editDependency(this.quest, selectedQuest, true)).setEnabled(selectedQuest != null && selectedQuest != this.quest && !selectedQuest.canRepeat));
                    }
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.quest);
            }
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (this.treeGui.movingQuest && selectedQuest == this.quest) {
                this.treeGui.movingQuest = false;
                this.treeGui.selectQuest(null);
                this.treeGui.selectQuest(this.quest);
            } else if (ButtonQuest.isCtrlKeyDown() && this.treeGui.file.canEdit()) {
                Quest q = this.treeGui.getSelectedQuest();
                if (q != null) {
                    this.treeGui.selectQuest(null);
                    this.treeGui.selectedQuests.add(q);
                }
                this.treeGui.selectedQuests.add(this.quest);
            } else if (!this.quest.guidePage.isEmpty() && this.quest.tasks.isEmpty() && this.quest.rewards.isEmpty() && this.quest.text.isEmpty()) {
                this.handleClick("guide", this.quest.guidePage);
            } else if (this.quest.customClick.isEmpty() || !this.handleClick(this.quest.customClick)) {
                this.treeGui.open(this.quest);
            }
        } else if (this.treeGui.file.canEdit() && button.isMiddle()) {
            this.treeGui.movingQuest = true;
            this.treeGui.selectQuest(this.quest);
        }
    }

    private void editDependency(Quest quest, QuestObject object, boolean add) {
        ArrayList<Dependency> prevDeps = new ArrayList<Dependency>(quest.dependencies);
        if (add != quest.hasDependency(object)) {
            if (add) {
                Dependency d = new Dependency();
                d.object = object;
                d.type = EnumDependencyType.REQUIRED;
                quest.dependencies.add(d);
            } else {
                for (int i = 0; i < quest.dependencies.size(); ++i) {
                    if (quest.dependencies.get((int)i).object != object) continue;
                    quest.dependencies.remove(i);
                    break;
                }
            }
        }
        if (quest.verifyDependencies(false)) {
            new MessageEditObjectDirect(quest).sendToServer();
            this.treeGui.quests.refreshWidgets();
        } else {
            quest.dependencies.clear();
            quest.dependencies.addAll(prevDeps);
            GuiQuestTree.displayError((ITextComponent)new TextComponentTranslation("ftbquests.gui.looping_dependencies", new Object[0]));
        }
    }

    @Nullable
    public Object getJEIFocus() {
        return this.quest.tasks.size() == 1 ? this.quest.tasks.get(0).getJEIFocus() : null;
    }

    public void addMouseOverText(List<String> list) {
        int p;
        String title = this.getTitle();
        if (this.treeGui.file.self != null && (p = this.quest.getRelativeProgress(this.treeGui.file.self)) > 0 && p < 100) {
            title = title + " " + TextFormatting.DARK_GRAY + p + "%";
        }
        list.add(title);
        if (!this.description.isEmpty()) {
            list.add(this.description);
        }
        if (this.treeGui.file.self != null && this.quest.isComplete(this.treeGui.file.self)) {
            int r = 0;
            for (QuestReward reward : this.quest.rewards) {
                if (this.treeGui.file.isRewardClaimed(reward)) continue;
                ++r;
            }
            if (r > 0 || this.quest.canRepeat) {
                list.add("");
            }
            if (r > 0) {
                list.add(I18n.func_135052_a((String)"ftbquests.gui.unclaimed_rewards", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + r);
            }
        }
    }

    public WidgetType getWidgetType() {
        if (this.treeGui.getSelectedQuest() == this.quest) {
            return WidgetType.MOUSE_OVER;
        }
        return this.treeGui.file.editingMode || this.quest.getVisibility(this.treeGui.file.self).isVisible() ? super.getWidgetType() : WidgetType.DISABLED;
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        double s1;
        boolean cantStart;
        Color4I outlineColor = Color4I.WHITE.withAlpha(150);
        Color4I qicon = Icon.EMPTY;
        boolean bl = cantStart = this.treeGui.file.self == null || !this.quest.canStartTasks(this.treeGui.file.self);
        if (!cantStart) {
            int progress = this.quest.getRelativeProgress(this.treeGui.file.self);
            if (progress >= 100) {
                boolean hasRewards = false;
                for (QuestReward reward : this.quest.rewards) {
                    if (this.treeGui.file.isRewardClaimed(reward)) continue;
                    hasRewards = true;
                    break;
                }
                qicon = hasRewards ? FTBQuestsTheme.ALERT : FTBQuestsTheme.COMPLETED;
                outlineColor = COL_COMPLETED.withAlpha(200);
            } else if (progress > 0) {
                outlineColor = COL_STARTED.withAlpha(200);
            }
        } else {
            outlineColor = Color4I.GRAY;
        }
        double s = this.treeGui.zoomd * 3.0 / 2.0;
        double sx = (double)x + ((double)w - s) / 2.0;
        double sy = (double)y + ((double)h - s) / 2.0;
        if (this.treeGui.selectedQuests.contains(this.quest)) {
            s1 = s + this.treeGui.zoomd / 5.0;
            double sx1 = (double)x + ((double)w - s1) / 2.0;
            double sy1 = (double)y + ((double)h - s1) / 2.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)sx1, (double)sy1, (double)0.0);
            GlStateManager.func_179139_a((double)s1, (double)s1, (double)1.0);
            this.quest.shape.outline.draw(0, 0, 1, 1, Color4I.WHITE.withAlpha(150 + (int)(Math.sin((double)System.currentTimeMillis() * 0.003) * 80.0)));
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
        GlStateManager.func_179139_a((double)s, (double)s, (double)1.0);
        this.quest.shape.shape.draw(0, 0, 1, 1, Color4I.DARK_GRAY);
        this.quest.shape.background.draw(0, 0, 1, 1, Color4I.WHITE.withAlpha(150));
        this.quest.shape.outline.draw(0, 0, 1, 1, outlineColor);
        GlStateManager.func_179121_F();
        if (!this.icon.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)x + ((double)w - this.treeGui.zoomd) / 2.0), (double)((double)y + ((double)h - this.treeGui.zoomd) / 2.0), (double)0.0);
            GlStateManager.func_179139_a((double)this.treeGui.zoomd, (double)this.treeGui.zoomd, (double)1.0);
            this.icon.draw(0, 0, 1, 1);
            GlStateManager.func_179121_F();
        }
        if (cantStart) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)sx, (double)sy, (double)500.0);
            GlStateManager.func_179139_a((double)s, (double)s, (double)1.0);
            this.quest.shape.shape.draw(0, 0, 1, 1, Color4I.BLACK.withAlpha(100));
            GlStateManager.func_179121_F();
        }
        if (this.isMouseOver()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)sx, (double)sy, (double)500.0);
            GlStateManager.func_179139_a((double)s, (double)s, (double)1.0);
            this.quest.shape.shape.draw(0, 0, 1, 1, Color4I.WHITE.withAlpha(50));
            GlStateManager.func_179121_F();
        }
        if (!qicon.isEmpty()) {
            s1 = this.treeGui.zoomd / 2.0;
            double os1 = s1 / 4.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)(x + w) - s1 - os1), (double)((double)y + os1), (double)500.0);
            GlStateManager.func_179139_a((double)s1, (double)s1, (double)1.0);
            qicon.draw(0, 0, 1, 1);
            GlStateManager.func_179121_F();
        }
    }
}

