/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class ButtonTask
extends SimpleTextButton {
    public final GuiQuestTree treeGui;
    public QuestTask task;

    public ButtonTask(Panel panel, QuestTask t) {
        super(panel, t.getDisplayName().func_150254_d(), GuiIcons.ACCEPT);
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.task = t;
    }

    public boolean hasIcon() {
        return true;
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            GuiHelper.playClickSound();
            this.task.onButtonClicked();
        } else if (button.isRight() && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.task);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getJEIFocus() {
        return this.task.getJEIFocus();
    }

    public void addMouseOverText(List<String> list) {
        QuestTaskData data;
        if (ButtonTask.isShiftKeyDown() && ButtonTask.isCtrlKeyDown()) {
            list.add(TextFormatting.DARK_GRAY + this.task.toString());
        }
        if (this.treeGui.file.self != null && this.task.quest.canStartTasks(this.treeGui.file.self)) {
            data = this.treeGui.file.self.getQuestTaskData(this.task);
            if (this.task.hideProgressNumbers()) {
                list.add(TextFormatting.DARK_GREEN + "[" + data.getRelativeProgress() + "%]");
            } else {
                String max = ButtonTask.isShiftKeyDown() ? Long.toUnsignedString(this.task.getMaxProgress()) : this.task.getMaxProgressString();
                String prog = ButtonTask.isShiftKeyDown() ? Long.toUnsignedString(data.getProgress()) : data.getProgressString();
                list.add(TextFormatting.DARK_GREEN + (data.getProgress() > this.task.getMaxProgress() ? max : prog) + " / " + max + " [" + data.getRelativeProgress() + "%]");
            }
        } else {
            data = null;
            list.add(TextFormatting.DARK_GRAY + "[0%]");
        }
        this.task.addMouseOverText(list, data);
    }

    public WidgetType getWidgetType() {
        if (this.task.invalid || this.treeGui.file.self == null || !this.task.quest.canStartTasks(this.treeGui.file.self) || this.task.isComplete(this.treeGui.file.self)) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void drawIcon(Theme theme, int x, int y, int w, int h) {
        this.task.drawGUI(this.treeGui.file.self == null ? null : this.treeGui.file.self.getQuestTaskData(this.task), x, y, w, h);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        if (this.treeGui.file.self != null && this.task.isComplete(this.treeGui.file.self)) {
            FTBQuestsTheme.COMPLETED.draw(x + w - 9, y + 1, 8, 8);
        }
    }
}

