/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IIteratingConfig;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.gui.GuiVariables;
import com.feed_the_beast.ftbquests.gui.tree.ButtonSubscribe;
import com.feed_the_beast.ftbquests.gui.tree.PanelChapters;
import com.feed_the_beast.ftbquests.gui.tree.PanelOtherButtons;
import com.feed_the_beast.ftbquests.gui.tree.PanelQuestLeft;
import com.feed_the_beast.ftbquests.gui.tree.PanelQuestRight;
import com.feed_the_beast.ftbquests.gui.tree.PanelQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageChangeProgress;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectQuick;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.reward.RandomReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestTree
extends GuiBase {
    public final ClientQuestFile file;
    public int scrollWidth;
    public int scrollHeight;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed;
    public QuestChapter selectedChapter;
    public final HashSet<Quest> selectedQuests;
    public final Panel chapterPanel;
    public final Panel quests;
    public final Panel questLeft;
    public final Panel questRight;
    public final Panel otherButtons;
    public final ButtonSubscribe subscribe;
    public Color4I borderColor;
    public Color4I backgroundColor;
    public boolean movingQuest = false;
    public int zoom = 16;
    public double zoomd = 16.0;
    public long lastShiftPress = 0L;

    public GuiQuestTree(ClientQuestFile q) {
        this.file = q;
        this.selectedQuests = new HashSet();
        this.chapterPanel = new PanelChapters((Panel)this);
        this.chapterPanel.setHeight(20);
        this.selectedChapter = this.file.chapters.isEmpty() ? null : (QuestChapter)this.file.chapters.get(0);
        this.borderColor = Color4I.WHITE.withAlpha(88);
        this.backgroundColor = Color4I.WHITE.withAlpha(33);
        this.quests = new PanelQuests((Panel)this);
        this.questLeft = new PanelQuestLeft((Panel)this);
        this.questRight = new PanelQuestRight((Panel)this);
        this.otherButtons = new PanelOtherButtons((Panel)this);
        this.subscribe = new ButtonSubscribe((Panel)this);
        this.selectChapter(null);
    }

    @Nullable
    public Quest getSelectedQuest() {
        return this.selectedQuests.size() == 1 ? this.selectedQuests.iterator().next() : null;
    }

    public void addWidgets() {
        this.add((Widget)this.chapterPanel);
        this.add((Widget)this.quests);
        this.add((Widget)this.otherButtons);
        this.add((Widget)this.questLeft);
        this.add((Widget)this.questRight);
        this.add((Widget)this.subscribe);
    }

    public void alignWidgets() {
        this.otherButtons.alignWidgets();
        this.chapterPanel.alignWidgets();
        this.subscribe.setPos(this.width - 13, this.height - 13);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void selectChapter(@Nullable QuestChapter chapter) {
        if (this.selectedChapter != chapter) {
            this.movingQuest = false;
            this.selectQuest(null);
            this.selectedChapter = chapter;
            this.quests.setScrollX(0);
            this.quests.setScrollY(0);
            this.quests.refreshWidgets();
            this.resetScroll(true);
        }
    }

    public void selectQuest(@Nullable Quest quest) {
        Quest prev = this.getSelectedQuest();
        this.selectedQuests.clear();
        if (prev != quest) {
            if (quest != null) {
                this.selectedQuests.add(quest);
            }
            this.quests.refreshWidgets();
            this.questLeft.refreshWidgets();
            this.questRight.refreshWidgets();
        }
    }

    public void resetScroll(boolean realign) {
        if (realign) {
            this.quests.alignWidgets();
        }
        this.quests.setScrollX((this.scrollWidth - this.quests.width) / 2);
        this.quests.setScrollY((this.scrollHeight - this.quests.height) / 2);
    }

    public static void addObjectMenuItems(List<ContextMenuItem> contextMenu, final IOpenableGui gui, final QuestObjectBase object) {
        ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
        ConfigGroup g = object.createSubGroup(group);
        object.getConfig(g);
        if (!g.getValues().isEmpty()) {
            ArrayList<1> list = new ArrayList<1>();
            for (final ConfigValueInstance inst : g.getValues()) {
                if (!(inst.getValue() instanceof IIteratingConfig)) continue;
                String name = inst.getDisplayName().func_150254_d();
                if (!inst.getCanEdit()) {
                    name = TextFormatting.GRAY + name;
                }
                list.add(new ContextMenuItem(name, inst.getIcon(), null){

                    public void addMouseOverText(List<String> list) {
                        list.add(inst.getValue().getStringForGUI().func_150254_d());
                    }

                    public void onClicked(Panel panel, MouseButton button) {
                        inst.getValue().onClicked(gui, inst, button, () -> new MessageEditObjectQuick(object2.id, inst.getID(), inst.getValue()).sendToServer());
                    }

                    public void drawIcon(Theme theme, int x, int y, int w, int h) {
                        if (inst.getValue() instanceof ConfigBoolean) {
                            (inst.getValue().getBoolean() ? GuiIcons.ACCEPT : GuiIcons.ACCEPT_GRAY).draw(x, y, w, h);
                        } else {
                            super.drawIcon(theme, x, y, w, h);
                        }
                    }
                });
            }
            if (!list.isEmpty()) {
                list.sort(null);
                contextMenu.addAll(list);
                contextMenu.add(ContextMenuItem.SEPARATOR);
            }
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, object::onEditButtonClicked));
        if (object instanceof RandomReward && ((RandomReward)object).getTable().id != 0) {
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_table.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> ((RandomReward)object).getTable().onEditButtonClicked()));
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> ClientQuestFile.INSTANCE.deleteObject(object.id)).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{object.getDisplayName().func_150254_d()})));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), GuiIcons.REFRESH, () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), object.id, EnumChangeProgress.RESET_DEPS).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
        if (object instanceof QuestObject) {
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), FTBQuestsTheme.COMPLETED, () -> new MessageChangeProgress(ClientQuestFile.INSTANCE.self.getTeamUID(), object.id, EnumChangeProgress.COMPLETE_DEPS).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
        }
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.copy_id", (Object[])new Object[0]), GuiIcons.INFO, () -> GuiQuestTree.setClipboardString((String)object.getCodeString())){

            public void addMouseOverText(List<String> list) {
                list.add(object.getCodeString());
            }
        });
    }

    public static void displayError(ITextComponent error) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TextComponentTranslation("ftbquests.gui.error", new Object[0]), error));
    }

    public boolean keyPressed(int key, char keyChar) {
        if (super.keyPressed(key, keyChar)) {
            return true;
        }
        if (key == 15) {
            if (this.selectedChapter != null && this.file.chapters.size() > 1) {
                this.selectChapter((QuestChapter)this.file.chapters.get(MathUtils.mod((int)(this.selectedChapter.getIndex() + (GuiQuestTree.isShiftKeyDown() ? -1 : 1)), (int)this.file.chapters.size())));
            }
            return true;
        }
        if (keyChar >= '1' && keyChar <= '9') {
            int i = keyChar - 49;
            if (i < this.file.chapters.size()) {
                this.selectChapter((QuestChapter)this.file.chapters.get(i));
            }
            return true;
        }
        if (this.selectedChapter != null && this.file.canEdit() && GuiQuestTree.isCtrlKeyDown() && !GuiQuestTree.isShiftKeyDown() && !GuiQuestTree.isAltKeyDown()) {
            switch (key) {
                case 30: {
                    this.movingQuest = false;
                    this.selectQuest(null);
                    this.selectedQuests.addAll(this.selectedChapter.quests);
                    break;
                }
                case 32: {
                    this.movingQuest = false;
                    this.selectQuest(null);
                    break;
                }
                case 208: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, quest.x, (byte)(quest.y + 1)).sendToServer();
                    }
                    this.movingQuest = false;
                    break;
                }
                case 200: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, quest.x, (byte)(quest.y - 1)).sendToServer();
                    }
                    this.movingQuest = false;
                    break;
                }
                case 203: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, (byte)(quest.x - 1), quest.y).sendToServer();
                    }
                    this.movingQuest = false;
                    break;
                }
                case 205: {
                    this.movingQuest = true;
                    for (Quest quest : this.selectedQuests) {
                        new MessageMoveQuest(quest.id, (byte)(quest.x + 1), quest.y).sendToServer();
                    }
                    this.movingQuest = false;
                }
            }
            return true;
        }
        if (key == 42) {
            long now = System.currentTimeMillis();
            if (this.lastShiftPress == 0L) {
                this.lastShiftPress = now;
            } else {
                if (now - this.lastShiftPress <= 400L) {
                    ConfigQuestObject c = new ConfigQuestObject((QuestFile)this.file, null, QuestObjectType.CHAPTER, QuestObjectType.QUEST);
                    GuiSelectQuestObject gui = new GuiSelectQuestObject(c, (IOpenableGui)this, () -> {
                        QuestObjectBase o = c.getObject();
                        if (o instanceof QuestChapter) {
                            this.selectChapter((QuestChapter)o);
                        } else if (o instanceof Quest) {
                            this.zoom = 20;
                            this.selectChapter(((Quest)o).chapter);
                            this.selectQuest((Quest)o);
                        }
                    });
                    gui.focus();
                    gui.setTitle(I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]));
                    gui.openGui();
                }
                this.lastShiftPress = 0L;
            }
        }
        return false;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.zoomd < (double)this.zoom) {
            this.zoomd += MathHelper.func_151237_a((double)(((double)this.zoom - this.zoomd) / 8.0), (double)0.1, (double)0.8);
            if (this.zoomd > (double)this.zoom) {
                this.zoomd = this.zoom;
            }
            this.grabbed = 0;
            this.resetScroll(true);
        } else if (this.zoomd > (double)this.zoom) {
            this.zoomd -= MathHelper.func_151237_a((double)((this.zoomd - (double)this.zoom) / 8.0), (double)0.1, (double)0.8);
            if (this.zoomd < (double)this.zoom) {
                this.zoomd = this.zoom;
            }
            this.grabbed = 0;
            this.resetScroll(true);
        }
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null && !this.file.chapters.isEmpty()) {
            this.selectChapter((QuestChapter)this.file.chapters.get(0));
        }
        super.drawBackground(theme, x, y, w, h);
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.quests.width) {
                this.quests.setScrollX(Math.max(Math.min(this.quests.getScrollX() + (this.prevMouseX - mx), this.scrollWidth - this.quests.width), 0));
            } else {
                this.quests.setScrollX((this.scrollWidth - this.quests.width) / 2);
            }
            if (this.scrollHeight > this.quests.height) {
                this.quests.setScrollY(Math.max(Math.min(this.quests.getScrollY() + (this.prevMouseY - my), this.scrollHeight - this.quests.height), 0));
            } else {
                this.quests.setScrollY((this.scrollHeight - this.quests.height) / 2);
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)this.borderColor, (boolean)false);
        int start = 1;
        if (!this.chapterPanel.widgets.isEmpty()) {
            Widget last = (Widget)this.chapterPanel.widgets.get(this.chapterPanel.widgets.size() - 1);
            start = last.getX() + last.width + 1;
        }
        this.backgroundColor.draw(start, y + 1, w - start - this.otherButtons.width - 1, this.chapterPanel.height - 2);
        this.borderColor.draw(start, y + this.chapterPanel.height - 1, w - start - 1, 1);
        Quest selectedQuest = this.getSelectedQuest();
        if (selectedQuest != null && !this.movingQuest) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            String txt = selectedQuest.getDisplayName().func_150254_d();
            int txts = theme.getStringWidth(txt);
            GuiHelper.drawHollowRect((int)2, (int)(this.chapterPanel.height + 1), (int)(txts + 6), (int)14, (Color4I)this.borderColor, (boolean)false);
            theme.drawGui(3, this.chapterPanel.height + 2, txts + 4, 12, WidgetType.DISABLED);
            theme.drawString(txt, 5, this.chapterPanel.height + 4);
            GlStateManager.func_179121_F();
        }
        super.drawForeground(theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public void open(@Nullable QuestObject object) {
        if (object instanceof QuestVariable) {
            new GuiVariables().openGui();
            return;
        }
        if (object instanceof QuestChapter) {
            this.selectChapter((QuestChapter)object);
        } else if (object instanceof Quest) {
            this.selectChapter(((Quest)object).chapter);
            this.selectQuest((Quest)object);
        } else if (object instanceof QuestTask) {
            this.selectChapter(((QuestTask)object).quest.chapter);
            this.selectQuest(((QuestTask)object).quest);
        }
        this.openGui();
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(this.file.getID(path)));
            return true;
        }
        return super.handleClick(scheme, path);
    }
}

