/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.TextField;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.WidgetVerticalSpace;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddTask;
import com.feed_the_beast.ftbquests.gui.tree.ButtonQuickComplete;
import com.feed_the_beast.ftbquests.gui.tree.ButtonTask;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.gui.tree.LabelCanRepeatQuest;
import com.feed_the_beast.ftbquests.quest.Dependency;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class PanelQuestLeft
extends Panel {
    public final GuiQuestTree treeGui;
    private int maxScroll = 0;

    public PanelQuestLeft(Panel panel) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
    }

    public void addWidgets() {
        Quest selectedQuest = this.treeGui.getSelectedQuest();
        if (!this.treeGui.movingQuest && selectedQuest != null) {
            this.setPos(2, this.treeGui.chapterPanel.height + 16);
            TextField tasksTextField = new TextField((Panel)this).setText(TextFormatting.BLUE + I18n.func_135052_a((String)"ftbquests.tasks", (Object[])new Object[0]) + ":");
            this.add((Widget)tasksTextField);
            for (QuestTask task : selectedQuest.tasks) {
                this.add((Widget)new ButtonTask(this, task));
            }
            if (this.treeGui.file.canEdit()) {
                this.add((Widget)new ButtonAddTask(this, selectedQuest));
            }
            if (!selectedQuest.isComplete(ClientQuestFile.INSTANCE.self)) {
                this.add((Widget)new WidgetVerticalSpace((Panel)this, 2));
                this.add((Widget)new ButtonQuickComplete(this));
            }
            boolean addedText = false;
            for (Dependency dependency : selectedQuest.dependencies) {
                if (dependency.isInvalid()) continue;
                if (!addedText) {
                    addedText = true;
                    this.add((Widget)new WidgetVerticalSpace((Panel)this, 2));
                    this.add((Widget)new TextField((Panel)this).setText(TextFormatting.AQUA + I18n.func_135052_a((String)"ftbquests.gui.requires", (Object[])new Object[0]) + ":"));
                }
                ITextComponent component = dependency.object.getDisplayName().func_150259_f();
                component.func_150256_b().func_150238_a(TextFormatting.GRAY);
                component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, dependency.object.toString()));
                component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("gui.open", new Object[0])));
                this.add((Widget)new TextField((Panel)this).setText(component));
            }
            addedText = false;
            for (QuestChapter chapter : this.treeGui.file.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.hasDependency(selectedQuest)) continue;
                    if (!addedText) {
                        addedText = true;
                        this.add((Widget)new WidgetVerticalSpace((Panel)this, 2));
                        this.add((Widget)new TextField((Panel)this).setText(TextFormatting.YELLOW + I18n.func_135052_a((String)"ftbquests.gui.required_by", (Object[])new Object[0]) + ":"));
                    }
                    ITextComponent component = quest.getDisplayName().func_150259_f();
                    component.func_150256_b().func_150238_a(TextFormatting.GRAY);
                    component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, quest.toString()));
                    component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("gui.open", new Object[0])));
                    this.add((Widget)new TextField((Panel)this).setText(component));
                }
            }
            this.setWidth(20);
            for (Widget widget : this.widgets) {
                this.setWidth(Math.max(this.width, widget.width + 6));
            }
            if (this.width > 150) {
                this.setWidth(150);
            }
            this.setHeight(Math.min(this.treeGui.height - this.treeGui.chapterPanel.height - 18, this.align((WidgetLayout)new WidgetLayout.Vertical(3, 3, 3))));
            for (Widget widget : this.widgets) {
                widget.setWidth(this.width - 6);
                widget.setX(3);
            }
            if (selectedQuest.canRepeat) {
                this.add(new LabelCanRepeatQuest(this).setPosAndSize(this.width - 11, tasksTextField.posY, 8, 8));
            }
            this.maxScroll = 0;
            for (Widget widget : this.widgets) {
                this.maxScroll = Math.max(this.maxScroll, widget.posY + widget.height + 3);
            }
        }
        if (this.widgets.isEmpty()) {
            this.setPosAndSize(-100, 0, 0, 0);
        }
    }

    public void alignWidgets() {
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }

    public boolean mouseScrolled(int scroll) {
        if (this.isMouseOver()) {
            this.setScrollY(MathHelper.func_76125_a((int)(this.getScrollY() - scroll / 10), (int)0, (int)(this.maxScroll - this.height)));
            return true;
        }
        return super.mouseScrolled(scroll);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        super.draw(theme, x, y, w, h);
        GlStateManager.func_179121_F();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (w > 0) {
            GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)this.treeGui.borderColor, (boolean)false);
            theme.drawGui(x + 1, y + 1, w - 2, h - 2, WidgetType.DISABLED);
        }
    }
}

