/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.TextField;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.WidgetVerticalSpace;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddReward;
import com.feed_the_beast.ftbquests.gui.tree.ButtonOpenInGuide;
import com.feed_the_beast.ftbquests.gui.tree.ButtonReward;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class PanelQuestRight
extends Panel {
    public final GuiQuestTree treeGui;
    private int maxScroll = 0;

    public PanelQuestRight(Panel panel) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
    }

    public void addWidgets() {
        Quest quest = this.treeGui.getSelectedQuest();
        if (quest != null && !this.treeGui.movingQuest) {
            this.setY(this.treeGui.chapterPanel.height + 1);
            ArrayList<SimpleTextButton> afterText = new ArrayList<SimpleTextButton>();
            if (!quest.guidePage.isEmpty()) {
                afterText.add(new ButtonOpenInGuide(this, quest));
                afterText.add((SimpleTextButton)new WidgetVerticalSpace((Panel)this, 4));
            }
            afterText.add((SimpleTextButton)new TextField((Panel)this).setText(TextFormatting.GOLD + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]) + ":"));
            if (quest.rewards.isEmpty()) {
                afterText.add((SimpleTextButton)new TextField((Panel)this).setText(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.gui.no_rewards", (Object[])new Object[0])));
            } else {
                for (QuestReward questReward : quest.rewards) {
                    afterText.add(new ButtonReward(this, questReward));
                }
            }
            if (this.treeGui.file.canEdit()) {
                afterText.add(new ButtonAddReward(this, quest));
            }
            this.setWidth(80);
            if (!quest.description.isEmpty()) {
                this.setWidth(Math.max(this.width, Math.min(180, this.treeGui.getTheme().getStringWidth(quest.description) + 6)));
            }
            if (!quest.text.isEmpty()) {
                this.setWidth(Math.max(this.width, 180));
            }
            for (Widget widget : afterText) {
                this.setWidth(Math.max(this.width, widget.width + 6));
            }
            if (this.width > 150) {
                this.setWidth(150);
            }
            if (!quest.description.isEmpty()) {
                this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width - 3).setSpacing(9).setText(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + StringUtils.addFormatting((String)quest.description)));
                this.add((Widget)new WidgetVerticalSpace((Panel)this, 5));
            }
            if (!quest.text.isEmpty()) {
                this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width - 3).setSpacing(9).setText(StringUtils.addFormatting((String)StringJoiner.with((char)'\n').join(quest.text))));
                this.add((Widget)new WidgetVerticalSpace((Panel)this, 10));
            }
            this.addAll(afterText);
            this.setHeight(Math.min(this.treeGui.height - this.treeGui.chapterPanel.height - 3, this.align((WidgetLayout)new WidgetLayout.Vertical(3, 3, 3))));
            for (Widget widget : this.widgets) {
                widget.setWidth(this.width - 6);
                widget.setX(3);
            }
            this.setX(this.treeGui.width - this.width - 2);
            this.maxScroll = 0;
            for (Widget widget : this.widgets) {
                this.maxScroll = Math.max(this.maxScroll, widget.posY + widget.height + 3);
            }
        }
        if (this.widgets.isEmpty()) {
            this.setPosAndSize(-100, 0, 0, 0);
        }
    }

    public void alignWidgets() {
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }

    public boolean mouseScrolled(int scroll) {
        if (this.isMouseOver()) {
            this.setScrollY(MathHelper.func_76125_a((int)(this.getScrollY() - scroll / 10), (int)0, (int)(this.maxScroll - this.height)));
            return true;
        }
        return super.mouseScrolled(scroll);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        super.draw(theme, x, y, w, h);
        GlStateManager.func_179121_F();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (w > 0) {
            GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)this.treeGui.borderColor, (boolean)false);
            theme.drawGui(x + 1, y + 1, w - 2, h - 2, WidgetType.DISABLED);
        }
    }
}

