/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.net.FTBQuestsNetHandler;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Collection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncQuests
extends MessageToClient {
    public QuestFile file;
    public short team;
    public Collection<TeamInst> teamData;
    public boolean editingMode;
    public IntCollection rewards;

    public MessageSyncQuests() {
    }

    public MessageSyncQuests(QuestFile f, short t, Collection<TeamInst> td, boolean e, IntCollection r) {
        this.file = f;
        this.team = t;
        this.teamData = td;
        this.editingMode = e;
        this.rewards = r;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        this.file.writeNetDataFull(data);
        data.writeShort((int)this.team);
        data.writeCollection(this.teamData, TeamInst.SERIALIZER);
        data.writeBoolean(this.editingMode);
        data.writeIntList(this.rewards);
    }

    public void readData(DataIn data) {
        this.file = new ClientQuestFile();
        this.file.readNetDataFull(data);
        this.team = data.readShort();
        this.teamData = data.readCollection(TeamInst.DESERIALIZER);
        this.editingMode = data.readBoolean();
        this.rewards = data.readIntList();
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        ((ClientQuestFile)this.file).load(this);
    }

    public static class TeamInst {
        public static final DataOut.Serializer<TeamInst> SERIALIZER = (data, t) -> {
            int i;
            data.writeShort((int)t.uid);
            data.writeString(t.id);
            data.writeTextComponent(t.name);
            data.writeVarInt(t.taskKeys.length);
            for (i = 0; i < t.taskKeys.length; ++i) {
                data.writeInt(t.taskKeys[i]);
                data.writeNBTBase(t.taskValues[i]);
            }
            data.writeVarInt(t.variableKeys.length);
            for (i = 0; i < t.variableKeys.length; ++i) {
                data.writeInt(t.variableKeys[i]);
                data.writeVarLong(t.variableValues[i]);
            }
        };
        public static final DataIn.Deserializer<TeamInst> DESERIALIZER = data -> {
            int i;
            TeamInst t = new TeamInst();
            t.uid = data.readShort();
            t.id = data.readString();
            t.name = data.readTextComponent();
            t.taskKeys = new int[data.readVarInt()];
            t.taskValues = new NBTBase[t.taskKeys.length];
            for (i = 0; i < t.taskKeys.length; ++i) {
                t.taskKeys[i] = data.readInt();
                t.taskValues[i] = data.readNBTBase();
            }
            t.variableKeys = new int[data.readVarInt()];
            t.variableValues = new long[t.variableKeys.length];
            for (i = 0; i < t.variableKeys.length; ++i) {
                t.variableKeys[i] = data.readInt();
                t.variableValues[i] = data.readVarLong();
            }
            return t;
        };
        public short uid;
        public String id;
        public ITextComponent name;
        public int[] taskKeys;
        public NBTBase[] taskValues;
        public int[] variableKeys;
        public long[] variableValues;
    }
}

