/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net.edit;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.edit.FTBQuestsEditNetHandler;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCreateObjectResponse
extends MessageToClient {
    private int id;
    private int parent;
    private QuestObjectType type;
    private NBTTagCompound nbt;
    private NBTTagCompound extra;

    public MessageCreateObjectResponse() {
    }

    public MessageCreateObjectResponse(QuestObjectBase o, @Nullable NBTTagCompound e) {
        this.id = o.id;
        this.parent = o.getParentID();
        this.type = o.getObjectType();
        this.nbt = new NBTTagCompound();
        o.writeData(this.nbt);
        this.extra = e;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsEditNetHandler.EDIT;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.id);
        data.writeInt(this.parent);
        data.write((Object)this.type, QuestObjectType.NAME_MAP);
        data.writeNBT(this.nbt);
        data.writeNBT(this.extra);
    }

    public void readData(DataIn data) {
        this.id = data.readInt();
        this.parent = data.readInt();
        this.type = (QuestObjectType)((Object)QuestObjectType.NAME_MAP.read(data));
        this.nbt = data.readNBT();
        this.extra = data.readNBT();
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        QuestObjectBase object = ClientQuestFile.INSTANCE.create(this.type, this.parent, this.extra == null ? new NBTTagCompound() : this.extra);
        object.readData(this.nbt);
        object.id = this.id;
        object.onCreated();
        ClientQuestFile.INSTANCE.refreshIDMap();
        object.editedFromGUI();
        FTBQuestsJEIHelper.refresh(object);
    }
}

