/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObjectResponse;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.task.KillTask;
import com.feed_the_beast.ftbquests.quest.task.LocationTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.util.FTBQuestsTeamData;
import io.sommers.packmode.api.PackModeAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;

public class ServerQuestFile
extends QuestFile {
    public static ServerQuestFile INSTANCE;
    public final Universe universe;
    public boolean shouldSave = false;
    private boolean isLoading = false;
    private List<KillTask> killTasks = null;
    private List<LocationTask> locationTasks = null;

    public ServerQuestFile(Universe u) {
        this.universe = u;
    }

    private String getFolderName() {
        if (this.universe.world.func_82736_K().func_82765_e("questfile")) {
            return this.universe.world.func_82736_K().func_82767_a("questfile");
        }
        if (Loader.isModLoaded((String)"packmode")) {
            return ServerQuestFile.getPackmodeFolderName();
        }
        return "normal";
    }

    private static String getPackmodeFolderName() {
        return PackModeAPI.getInstance().getCurrentPackMode();
    }

    public void load() {
        File folder = new File(Loader.instance().getConfigDir(), "ftbquests/" + this.getFolderName());
        if (folder.exists()) {
            FTBQuests.LOGGER.info("Loading quests from " + folder.getAbsolutePath());
            this.isLoading = true;
            this.readDataFull(folder);
            this.isLoading = false;
        } else {
            NBTTagCompound nbt;
            File old = new File(this.universe.server.func_71238_n(), "questpacks/" + this.getFolderName() + ".nbt");
            if (old.exists() && (nbt = NBTUtils.readNBT((File)old)) != null) {
                File[] p;
                FTBQuests.LOGGER.info("Loading old quests file from " + old.getAbsolutePath());
                this.isLoading = true;
                this.readDataOld(nbt);
                this.isLoading = false;
                FileUtils.deleteSafe((File)old);
                if (!(((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue() || (p = old.getParentFile().listFiles()) != null && p.length != 0)) {
                    FileUtils.deleteSafe((File)old.getParentFile());
                }
            }
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    @Nullable
    public ITeamData getData(short team) {
        if (team == 0) {
            return null;
        }
        ForgeTeam t = this.universe.getTeam(team);
        return t.isValid() ? FTBQuestsTeamData.get(t) : null;
    }

    @Override
    @Nullable
    public ITeamData getData(String team) {
        if (team.isEmpty()) {
            return null;
        }
        ForgeTeam t = this.universe.getTeam(team);
        return t.isValid() ? FTBQuestsTeamData.get(t) : null;
    }

    public Collection<FTBQuestsTeamData> getAllData() {
        Collection teams = this.universe.getTeams();
        ArrayList<FTBQuestsTeamData> list = new ArrayList<FTBQuestsTeamData>(teams.size());
        for (ForgeTeam team : teams) {
            if (!team.isValid()) continue;
            list.add(FTBQuestsTeamData.get(team));
        }
        return list;
    }

    @Override
    public void deleteObject(int id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            this.refreshIDMap();
            this.save();
            File file = object.getFile(new File(Loader.instance().getConfigDir(), "ftbquests/" + this.getFolderName()));
            if (file != null) {
                FileUtils.deleteSafe((File)file);
            }
        }
        new MessageDeleteObjectResponse(id).sendToAll();
    }

    public void save() {
        this.shouldSave = true;
        this.universe.markDirty();
    }

    public void saveNow() {
        this.writeDataFull(new File(Loader.instance().getConfigDir(), "ftbquests/" + this.getFolderName()));
    }

    public void unload() {
        if (this.shouldSave) {
            this.saveNow();
            this.shouldSave = false;
        }
        this.deleteChildren();
        this.deleteSelf();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.killTasks = null;
        this.locationTasks = null;
    }

    public final List<KillTask> getKillTasks() {
        if (this.killTasks == null) {
            this.killTasks = new ArrayList<KillTask>();
            for (QuestChapter chapter : this.chapters) {
                for (Quest quest : chapter.quests) {
                    for (QuestTask task : quest.tasks) {
                        if (!(task instanceof KillTask)) continue;
                        this.killTasks.add((KillTask)task);
                    }
                }
            }
        }
        return this.killTasks;
    }

    public final List<LocationTask> getLocationTasks() {
        if (this.locationTasks == null) {
            this.locationTasks = new ArrayList<LocationTask>();
            for (QuestChapter chapter : this.chapters) {
                for (Quest quest : chapter.quests) {
                    for (QuestTask task : quest.tasks) {
                        if (!(task instanceof LocationTask)) continue;
                        this.locationTasks.add((LocationTask)task);
                    }
                }
            }
        }
        return this.locationTasks;
    }
}

