/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.loot;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.gui.GuiEditRewardTable;
import com.feed_the_beast.ftbquests.gui.GuiRewardTables;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectDirect;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class RewardTable
extends QuestObjectBase {
    public final QuestFile file;
    public final List<WeightedReward> rewards;
    public final Quest fakeQuest;
    public int emptyWeight;
    public int lootSize;
    public boolean hideTooltip;
    public boolean useTitle;
    public LootCrate lootCrate;

    public RewardTable(QuestFile f) {
        this.file = f;
        this.rewards = new ArrayList<WeightedReward>();
        this.fakeQuest = new Quest(new QuestChapter(this.file));
        this.emptyWeight = 9;
        this.lootSize = 27;
        this.hideTooltip = false;
        this.useTitle = false;
        this.lootCrate = null;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.REWARD_TABLE;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    public int getTotalWeight(boolean includeEmpty) {
        int w = includeEmpty ? this.emptyWeight : 0;
        for (WeightedReward r : this.rewards) {
            w += r.weight;
        }
        return w;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.emptyWeight > 0) {
            nbt.func_74768_a("empty_weight", this.emptyWeight);
        }
        nbt.func_74768_a("loot_size", this.lootSize);
        if (this.hideTooltip) {
            nbt.func_74757_a("hide_tooltip", true);
        }
        if (this.useTitle) {
            nbt.func_74757_a("use_title", true);
        }
        NBTTagList list = new NBTTagList();
        for (WeightedReward reward : this.rewards) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            reward.reward.writeData(nbt1);
            if (reward.reward.getType() != FTBQuestsRewards.ITEM) {
                nbt1.func_74778_a("type", reward.reward.getType().getTypeForNBT());
            }
            if (reward.weight > 1) {
                nbt1.func_74768_a("weight", reward.weight);
            }
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("rewards", (NBTBase)list);
        if (this.lootCrate != null) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            this.lootCrate.writeData(nbt1);
            nbt.func_74782_a("loot_crate", (NBTBase)nbt1);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.emptyWeight = nbt.func_74762_e("empty_weight");
        this.lootSize = nbt.func_74762_e("loot_size");
        this.hideTooltip = nbt.func_74767_n("hide_tooltip");
        this.useTitle = nbt.func_74767_n("use_title");
        this.rewards.clear();
        NBTTagList list = nbt.func_150295_c("rewards", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            QuestReward reward = QuestRewardType.createReward(this.fakeQuest, nbt1.func_74779_i("type"));
            if (reward == null) continue;
            reward.readData(nbt1);
            this.rewards.add(new WeightedReward(reward, nbt1.func_74762_e("weight")));
        }
        this.lootCrate = null;
        if (nbt.func_74764_b("loot_crate")) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readData(nbt.func_74775_l("loot_crate"));
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.emptyWeight);
        data.writeVarInt(this.lootSize);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.hideTooltip);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.useTitle);
        flags = Bits.setFlag((int)flags, (int)4, (this.lootCrate != null ? 1 : 0) != 0);
        data.writeVarInt(flags);
        data.writeVarInt(this.rewards.size());
        for (WeightedReward reward : this.rewards) {
            data.writeVarInt(QuestRewardType.getRegistry().getID((IForgeRegistryEntry)reward.reward.getType()));
            reward.reward.writeNetData(data);
            data.writeVarInt(reward.weight);
        }
        if (this.lootCrate != null) {
            this.lootCrate.writeNetData(data);
        }
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.emptyWeight = data.readVarInt();
        this.lootSize = data.readVarInt();
        int flags = data.readVarInt();
        this.hideTooltip = Bits.getFlag((int)flags, (int)1);
        this.useTitle = Bits.getFlag((int)flags, (int)2);
        boolean hasCrate = Bits.getFlag((int)flags, (int)4);
        this.rewards.clear();
        int s = data.readVarInt();
        for (int i = 0; i < s; ++i) {
            QuestRewardType type = (QuestRewardType)QuestRewardType.getRegistry().getValue(data.readVarInt());
            QuestReward reward = type.provider.create(this.fakeQuest);
            reward.readNetData(data);
            int w = data.readVarInt();
            this.rewards.add(new WeightedReward(reward, w));
        }
        this.lootCrate = null;
        if (hasCrate) {
            this.lootCrate = new LootCrate(this);
            this.lootCrate.readNetData(data);
        }
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("empty_weight", () -> this.emptyWeight, v -> {
            this.emptyWeight = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addInt("loot_size", () -> this.lootSize, v -> {
            this.lootSize = v;
        }, 27, 1, Integer.MAX_VALUE);
        config.addBool("hide_tooltip", () -> this.hideTooltip, v -> {
            this.hideTooltip = v;
        }, false);
        config.addBool("use_title", () -> this.useTitle, v -> {
            this.useTitle = v;
        }, false);
        if (this.lootCrate != null) {
            ConfigGroup lc = config.getGroup("loot_crate");
            lc.setDisplayName((ITextComponent)new TextComponentTranslation("item.ftbquests.lootcrate.name", new Object[0]));
            this.lootCrate.getConfig(lc);
        }
    }

    @Override
    public void deleteSelf() {
        this.file.rewardTables.remove(this);
        super.deleteSelf();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null && gui.getSelectedQuest() != null) {
            gui.questRight.refreshWidgets();
        } else {
            GuiRewardTables gui1 = (GuiRewardTables)((Object)ClientUtils.getCurrentGuiAs(GuiRewardTables.class));
            if (gui1 != null) {
                gui1.refreshWidgets();
            }
        }
    }

    @Override
    public void onCreated() {
        this.file.rewardTables.add(this);
    }

    @Override
    public File getFile(File folder) {
        return new File(folder, "reward_tables/" + this.getCodeString() + ".nbt");
    }

    @Override
    public Icon getAltIcon() {
        if (this.lootCrate != null) {
            return ItemIcon.getItemIcon((ItemStack)this.lootCrate.createStack());
        }
        if (this.rewards.isEmpty()) {
            return GuiIcons.DICE;
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (WeightedReward reward : this.rewards) {
            icons.add(reward.reward.getIcon());
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        if (this.rewards.size() == 1) {
            return this.rewards.get((int)0).reward.getDisplayName();
        }
        return new TextComponentTranslation("ftbquests.reward_table", new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onEditButtonClicked() {
        new GuiEditRewardTable(this, () -> new MessageEditObjectDirect(this).sendToServer()).openGui();
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list, boolean includeWeight, boolean includeEmpty) {
        List<WeightedReward> rewards1;
        if (this.hideTooltip) {
            return;
        }
        int totalWeight = this.getTotalWeight(includeEmpty);
        if (includeWeight && includeEmpty && this.emptyWeight > 0) {
            list.add(TextFormatting.GRAY + "- " + I18n.func_135052_a((String)"ftbquests.reward_table.nothing", (Object[])new Object[0]) + TextFormatting.DARK_GRAY + " [" + WeightedReward.chanceString(this.emptyWeight, totalWeight) + "]");
        }
        if (this.rewards.size() > 1) {
            rewards1 = new ArrayList<WeightedReward>(this.rewards);
            rewards1.sort(null);
        } else {
            rewards1 = this.rewards;
        }
        for (int i = 0; i < rewards1.size(); ++i) {
            if (i == 10) {
                list.add(TextFormatting.GRAY + "- " + I18n.func_135052_a((String)"ftbquests.reward_table.and_more", (Object[])new Object[]{rewards1.size() - 10}));
                return;
            }
            WeightedReward r = rewards1.get(i);
            if (includeWeight) {
                list.add(TextFormatting.GRAY + "- " + r.reward.getDisplayName().func_150254_d() + TextFormatting.DARK_GRAY + " [" + WeightedReward.chanceString(r.weight, totalWeight) + "]");
                continue;
            }
            list.add(TextFormatting.GRAY + "- " + r.reward.getDisplayName().func_150254_d());
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.LOOTCRATES;
    }
}

