/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestReward
extends QuestObjectBase {
    public QuestObjectBase parent;
    public boolean team;
    private boolean emergency;

    public QuestReward(QuestObjectBase q) {
        this.parent = q;
        this.team = this.parent.getQuestFile().defaultRewardTeam;
        this.emergency = false;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.parent.getQuestFile();
    }

    @Override
    @Nullable
    public final QuestChapter getQuestChapter() {
        return this.parent.getQuestChapter();
    }

    @Override
    public final int getParentID() {
        return this.parent.id;
    }

    public abstract QuestRewardType getType();

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.team != this.getQuestFile().defaultRewardTeam) {
            nbt.func_74757_a("team_reward", this.team);
        }
        if (this.emergency) {
            nbt.func_74757_a("emergency", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.team = nbt.func_74764_b("team_reward") ? nbt.func_74767_n("team_reward") : this.getQuestFile().defaultRewardTeam;
        this.emergency = nbt.func_74767_n("emergency");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.team);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.emergency);
        data.writeVarInt(flags);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        int flags = data.readVarInt();
        this.team = Bits.getFlag((int)flags, (int)1);
        this.emergency = Bits.getFlag((int)flags, (int)2);
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addBool("team", this::isTeamReward, v -> {
            this.team = v;
        }, false).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.team_reward", new Object[0])).setCanEdit(!(this.parent instanceof Quest) || !((Quest)this.parent).canRepeat);
    }

    public abstract void claim(EntityPlayerMP var1);

    public ItemStack claimAutomated(TileEntity tileEntity, @Nullable EntityPlayerMP player) {
        if (player != null) {
            MessageDisplayRewardToast.ENABLED = false;
            this.claim(player);
            MessageDisplayRewardToast.ENABLED = true;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public final void deleteSelf() {
        if (this.parent instanceof Quest) {
            ((Quest)this.parent).rewards.remove(this);
        }
        Set<QuestReward> c = Collections.singleton(this);
        for (ITeamData iTeamData : this.getQuestFile().getAllData()) {
            iTeamData.unclaimRewards(c);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        Set<QuestReward> c = Collections.singleton(this);
        for (ITeamData iTeamData : this.getQuestFile().getAllData()) {
            iTeamData.unclaimRewards(c);
        }
        super.deleteChildren();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null && gui.getSelectedQuest() != null) {
            gui.questRight.refreshWidgets();
        }
        if (gui != null) {
            gui.quests.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        if (this.parent instanceof Quest) {
            ((Quest)this.parent).rewards.add(this);
        }
    }

    public final boolean isTeamReward() {
        return this.team || this.parent instanceof Quest && ((Quest)this.parent).canRepeat;
    }

    public final boolean addToEmergencyItems() {
        return this.emergency;
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        QuestRewardType type = this.getType();
        return group.getGroup(this.getObjectType().func_176610_l()).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked() {
        new MessageClaimReward(this.id).sendToServer();
    }

    public boolean getExcludeFromClaimAll() {
        return this.getType().getExcludeFromListRewards();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Object getJEIFocus() {
        return this.getIcon().getJEIFocus();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }
}

