/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public abstract class SimpleQuestTaskData<T extends QuestTask>
extends QuestTaskData<T> {
    public long progress = 0L;

    @Nullable
    public static NBTBase longToNBT(long value) {
        if (value <= 0L) {
            return null;
        }
        if (value <= 127L) {
            return new NBTTagByte((byte)value);
        }
        if (value <= 32767L) {
            return new NBTTagShort((short)value);
        }
        if (value <= Integer.MAX_VALUE) {
            return new NBTTagInt((int)value);
        }
        return new NBTTagLong(value);
    }

    public SimpleQuestTaskData(T q, ITeamData d) {
        super(q, d);
    }

    @Override
    @Nullable
    public NBTBase toNBT() {
        return this.progress <= 0L ? null : SimpleQuestTaskData.longToNBT(this.progress);
    }

    @Override
    public void fromNBT(@Nullable NBTBase nbt) {
        this.progress = nbt instanceof NBTPrimitive ? ((NBTPrimitive)nbt).func_150291_c() : 0L;
    }

    @Override
    public long getProgress() {
        return this.progress;
    }

    @Override
    public void changeProgress(EnumChangeProgress type) {
        if (type.reset) {
            this.progress = 0L;
        } else if (type.complete) {
            this.progress = this.task.getMaxProgress();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Nullable
    public <C> C getCapability(Capability<C> capability, @Nullable EnumFacing facing) {
        return null;
    }
}

