/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class XPTask
extends QuestTask
implements ISingleLongValueTask {
    public long value = 1L;
    public boolean points = false;

    public XPTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.XP;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return Long.toUnsignedString(this.points && this.value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.value) : this.value);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
        nbt.func_74757_a("points", this.points);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
        this.points = nbt.func_74767_n("points");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
        data.writeBoolean(this.points);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
        this.points = data.readBoolean();
    }

    @Override
    public ConfigLong getDefaultValue() {
        return new ConfigLong(this.value, 1L, Long.MAX_VALUE);
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addBool("points", () -> this.points, v -> {
            this.points = v;
        }, false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        TextComponentString text = new TextComponentString(this.getMaxProgressString());
        text.func_150256_b().func_150238_a(TextFormatting.RED);
        return new TextComponentTranslation("ftbquests.reward.ftbquests.xp_levels", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)text);
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)XPTask.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = XPTask.getPlayerXP(player) + amount;
        player.field_71068_ca = XPTask.getLevelForExperience(experience);
        int expForLevel = XPTask.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return XPTask.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + XPTask.sum(level - 15, 37, 5);
        }
        return 1395 + XPTask.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = XPTask.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static class Data
    extends SimpleQuestTaskData<XPTask> {
        private Data(XPTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return Long.toUnsignedString(((XPTask)this.task).points && ((XPTask)this.task).value <= Integer.MAX_VALUE ? (long)XPTask.getLevelForExperience((int)this.progress) : this.progress);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            int add = (int)Math.min(((XPTask)this.task).points ? (long)XPTask.getPlayerXP((EntityPlayer)player) : (long)player.field_71068_ca, Math.min(((XPTask)this.task).value - this.progress, Integer.MAX_VALUE));
            if (add > 0) {
                if (!simulate) {
                    if (((XPTask)this.task).points) {
                        XPTask.addPlayerXP((EntityPlayer)player, -add);
                        player.func_82242_a(0);
                    } else {
                        player.func_82242_a(-add);
                    }
                    this.progress += (long)add;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

