/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.cfg.file1132.io;

import com.zeitheron.hammercore.cfg.file1132.ConfigEntrySerializer;
import com.zeitheron.hammercore.cfg.file1132.Configuration;
import com.zeitheron.hammercore.cfg.file1132.IConfigEntry;
import java.math.BigInteger;
import java.util.Objects;

public class ConfigEntryBigInt
implements IConfigEntry {
    final Configuration cfg;
    public BigInteger min;
    public BigInteger max;
    String description;
    String name;
    BigInteger value;
    BigInteger initialValue;

    public ConfigEntryBigInt(Configuration cfg, BigInteger initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryBigInt setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryBigInt setMinValue(BigInteger min) {
        this.min = min;
        if (this.value != null) {
            if (min != null) {
                this.value = this.value.max(min);
            }
            if (this.max != null) {
                this.value = this.value.min(this.max);
            }
        }
        return this;
    }

    public ConfigEntryBigInt setMaxValue(BigInteger max) {
        this.max = max;
        if (this.value != null) {
            if (this.min != null) {
                this.value = this.value.max(this.min);
            }
            if (max != null) {
                this.value = this.value.min(max);
            }
        }
        return this;
    }

    public ConfigEntryBigInt setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryBigInt setValue(BigInteger value) {
        if (value != null) {
            if (this.min != null) {
                value = value.max(this.min);
            }
            if (this.max != null) {
                value = value.min(this.max);
            }
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BigInteger getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return Configuration.SERIALIZER_BIG_INT;
    }
}

