/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.cfg.file1132.io;

import com.zeitheron.hammercore.cfg.file1132.ConfigEntrySerializer;
import com.zeitheron.hammercore.cfg.file1132.Configuration;
import com.zeitheron.hammercore.cfg.file1132.ReaderHelper;
import com.zeitheron.hammercore.cfg.file1132.io.ConfigEntryLong;
import java.io.BufferedWriter;
import java.io.IOException;

public class ConfigSerializerLong
extends ConfigEntrySerializer<ConfigEntryLong> {
    public ConfigSerializerLong() {
        super("L");
    }

    @Override
    public void write(Configuration config, BufferedWriter writer, ConfigEntryLong entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            this.writeComment(writer, entry.getDescription() + " (Default: " + entry.initialValue + ", Range: [" + entry.min + ";" + entry.max + "])", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getSerializedName() + "=" + entry.getValue() + "\n\n");
    }

    @Override
    public ConfigEntryLong read(Configuration config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryLong lnt = new ConfigEntryLong(config, null);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            String value = reader.getRest();
            if (value.contains("\n")) {
                value = value.substring(0, value.indexOf(10));
            }
            lnt.name = name;
            try {
                lnt.value = Math.max(lnt.min, Math.min(lnt.max, Long.parseLong(value)));
            }
            catch (NumberFormatException nfe) {
                lnt.value = null;
            }
        }
        return lnt;
    }
}

