/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.utils.texture.gui.theme.GuiTheme;
import com.zeitheron.hammercore.lib.zlib.json.JSONObject;
import com.zeitheron.hammercore.lib.zlib.json.JSONTokener;
import com.zeitheron.hammercore.lib.zlib.json.serapi.IgnoreSerialization;
import com.zeitheron.hammercore.lib.zlib.json.serapi.Jsonable;
import com.zeitheron.hammercore.lib.zlib.json.serapi.SerializationContext;
import com.zeitheron.hammercore.lib.zlib.json.serapi.SerializedName;
import com.zeitheron.hammercore.lib.zlib.utils.MD5;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.opts.PacketCHCOpts;
import java.io.FileOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HCClientOptions
implements Jsonable {
    public static HCClientOptions options = new HCClientOptions();
    @IgnoreSerialization
    public boolean def = true;
    @IgnoreSerialization
    private JSONObject data;
    @SerializedName(value="Authority")
    public String authority;
    public boolean renderSpecial = true;
    public boolean overrideCape;
    public int skinType;
    private String Theme;
    @IgnoreSerialization
    public NBTTagCompound customData = new NBTTagCompound();

    public NBTTagCompound getCustomData() {
        if (this.customData == null) {
            this.customData = new NBTTagCompound();
        }
        return this.customData;
    }

    public boolean checkAuthority() {
        for (HammerCore.HCAuthor au : HammerCore.getHCAuthors()) {
            if (!Minecraft.func_71410_x().func_110432_I().func_111285_a().equals(au.getUsername())) continue;
            return au.getStore().matches(this.authority);
        }
        return true;
    }

    public static boolean checkAuthority(String passcode) {
        for (HammerCore.HCAuthor au : HammerCore.getHCAuthors()) {
            if (au.getStore() == null || !Minecraft.func_71410_x().func_110432_I().func_111285_a().equals(au.getUsername())) continue;
            return au.getStore().matches(MD5.encrypt(passcode));
        }
        return true;
    }

    public void setDefaults() {
        this.setTheme("Vanilla");
        this.customData = new NBTTagCompound();
        this.renderSpecial = true;
        this.overrideCape = true;
        this.skinType = 0;
        this.authority = null;
        this.def = true;
    }

    public void load(JSONObject j) {
        this.def = false;
        if (this == HCClientOptions.getOptions()) {
            this.setTheme(j.optString("Theme"), false);
        }
        this.authority = j.optString("Authority", "0");
        this.renderSpecial = j.optBoolean("renderSpecial", true);
        this.overrideCape = j.optBoolean("overrideCape", true);
        this.skinType = j.optInt("SkinType");
        try {
            this.customData = JsonToNBT.func_180713_a((String)j.optString("CustomData"));
            HammerCore.renderProxy.cl_loadOpts(this, this.customData);
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
        this.data = j;
    }

    @Override
    public SerializationContext serializationContext() {
        SerializationContext c = new SerializationContext();
        if (this.customData == null) {
            this.customData = new NBTTagCompound();
        }
        HammerCore.renderProxy.cl_saveOpts(this, this.customData);
        c.set("CustomData", this.customData != null ? this.customData.toString() : "{}");
        return c;
    }

    public String getTheme() {
        return this.Theme;
    }

    public JSONObject getData() {
        return this.data;
    }

    public void setTheme(String theme) {
        this.setTheme(theme, true);
    }

    private void setTheme(String theme, boolean save) {
        for (GuiTheme t : GuiTheme.THEMES) {
            if (!t.name.equalsIgnoreCase(theme)) continue;
            GuiTheme.CURRENT_THEME = t;
            this.Theme = theme;
            if (save) {
                this.save();
            }
            return;
        }
        GuiTheme.CURRENT_THEME = GuiTheme.THEMES.get(0);
        this.Theme = GuiTheme.CURRENT_THEME.name;
    }

    public static HCClientOptions getOptions() {
        return options;
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream("hc_options.txt");
            fos.write(this.serialize().getBytes());
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadFrom(HCClientOptions o) {
        try {
            JSONObject j = (JSONObject)new JSONTokener(o.serialize()).nextValue();
            this.load(j);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void saveAndSendToServer() {
        this.save();
        EntityPlayer ep = HammerCore.renderProxy.getClientPlayer();
        if (ep != null) {
            HCNet.INSTANCE.sendToServer(new PacketCHCOpts().setPlayer(ep).setOpts(this));
        }
    }
}

