/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.gui;

import com.zeitheron.hammercore.lib.zlib.utils.IndexedMap;
import com.zeitheron.hammercore.utils.WorldLocation;
import java.util.function.BiFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IGuiCallback {
    default public void setGuiID(int id) {
        Vars.ids.put(id, this);
    }

    default public int getGuiID() {
        Integer i = (Integer)Vars.ids.getKey(this);
        return i != null ? i : 0;
    }

    public static IGuiCallback create(final BiFunction<EntityPlayer, WorldLocation, Object> client, final BiFunction<EntityPlayer, WorldLocation, Object> server) {
        return new IGuiCallback(){

            @Override
            public Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
                return server.apply(player, new WorldLocation(world, pos));
            }

            @Override
            public Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
                return client.apply(player, new WorldLocation(world, pos));
            }
        };
    }

    public Object getServerGuiElement(EntityPlayer var1, World var2, BlockPos var3);

    public Object getClientGuiElement(EntityPlayer var1, World var2, BlockPos var3);

    public static class Vars {
        private static final IndexedMap<Integer, IGuiCallback> ids = new IndexedMap();
    }
}

