/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.zeitheron.hammercore.ServerHCClientPlayerData;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class ClientSkinManager {
    private static final Map<String, String> playerSTs = new HashMap<String, String>();
    public static final Field playerTextures = NetworkPlayerInfo.class.getDeclaredFields()[1];
    public static final Field skinType = NetworkPlayerInfo.class.getDeclaredFields()[5];

    public static Map<MinecraftProfileTexture.Type, ResourceLocation> getPlayerMap(AbstractClientPlayer acp) {
        NetworkPlayerInfo npi = Minecraft.func_71410_x().func_147114_u().func_175102_a(acp.func_110124_au());
        String uuids = acp.func_110124_au().toString();
        if (!playerSTs.containsKey(uuids)) {
            try {
                playerSTs.put(uuids, "" + skinType.get(npi));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int skinTypei = ServerHCClientPlayerData.getOptionsFor((EntityPlayer)acp).skinType;
        try {
            skinType.set(npi, skinTypei == 0 ? playerSTs.get(uuids) : (skinTypei % 2 == 1 ? "default" : "slim"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return (Map)playerTextures.get(npi);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean bindTexture(AbstractClientPlayer acp, MinecraftProfileTexture.Type type, ResourceLocation location) {
        Map<MinecraftProfileTexture.Type, ResourceLocation> mp = ClientSkinManager.getPlayerMap(acp);
        if (mp != null) {
            mp.put(type, location);
            return true;
        }
        return false;
    }

    static {
        playerTextures.setAccessible(true);
        skinType.setAccessible(true);
    }
}

