/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture.def;

import com.zeitheron.hammercore.client.utils.texture.TextureSpriteFX;
import com.zeitheron.hammercore.utils.math.MathHelper;

public class TextureSpriteAnimationFX
extends TextureSpriteFX {
    private float[] red;
    private float[] green;
    private float[] blue;
    private float[] alpha;

    public TextureSpriteAnimationFX(int resolution) {
        super(resolution, "hammercore:animation_fx");
        this.setup();
    }

    @Override
    public void setup() {
        super.setup();
        this.red = new float[this.tileSizeSquare];
        this.green = new float[this.tileSizeSquare];
        this.blue = new float[this.tileSizeSquare];
        this.alpha = new float[this.tileSizeSquare];
    }

    @Override
    public void onTick() {
        float var3;
        for (int i = 0; i < this.tileSizeBase; ++i) {
            for (int j = 0; j < this.tileSizeBase; ++j) {
                var3 = -0.05f;
                int rotation1 = (int)(MathHelper.sin((float)j * (float)Math.PI * 3.0f / 2.0f) * 1.0);
                int rotation2 = (int)(MathHelper.sin((float)i * (float)Math.PI * 3.0f / 2.0f) * 1.0);
                for (int k = i - 1; k <= i + 1; ++k) {
                    for (int l = j - 1; l <= j + 1; ++l) {
                        int mod1 = k + rotation1 & this.tileSizeMask;
                        int mod2 = l + rotation2 & this.tileSizeMask;
                        var3 += this.red[mod1 + mod2 * this.tileSizeBase];
                    }
                }
                this.green[i + j * this.tileSizeBase] = var3 / 10.0f + (this.blue[(i & this.tileSizeMask) + (j & this.tileSizeMask) * this.tileSizeBase] + this.blue[(i + 1 & this.tileSizeMask) + (j & this.tileSizeMask) * this.tileSizeBase] + this.blue[(i + 1 & this.tileSizeMask) + (j + 1 & this.tileSizeMask) * this.tileSizeBase] + this.blue[(i & this.tileSizeMask) + (j + 1 & this.tileSizeMask) * this.tileSizeBase]) / 4.0f * 0.8f;
                int n = i + j * this.tileSizeBase;
                this.blue[n] = this.blue[n] + this.alpha[i + j * this.tileSizeBase] * 0.01f;
                if (this.blue[i + j * this.tileSizeBase] < 0.0f) {
                    this.blue[i + j * this.tileSizeBase] = 0.0f;
                }
                int n2 = i + j * this.tileSizeBase;
                this.alpha[n2] = this.alpha[n2] - 0.052f;
                if (!(Math.random() < 0.0055)) continue;
                this.alpha[i + j * this.tileSizeBase] = 1.33f;
            }
        }
        float[] var11 = this.green;
        this.green = this.red;
        this.red = var11;
        for (int i = 0; i < this.tileSizeSquare; ++i) {
            var3 = this.red[i] * 2.0f;
            var3 = MathHelper.clip(var3, 0.0f, 1.0f);
            int r = (int)(var3 * 255.0f);
            int g = (int)(var3 * 255.0f);
            int b = (int)(var3 * 255.0f);
            int a = (int)(MathHelper.clip(this.alpha[i] * 2.0f, 0.0f, 1.0f) * 255.0f);
            if (this.anaglyphEnabled) {
                int var8 = (r * 30 + g * 59 + b * 11) / 100;
                int var9 = (r * 30 + g * 70) / 100;
                int var10 = (r * 30 + b * 70) / 100;
                r = var8;
                g = var9;
                b = var10;
            }
            this.imageData[i] = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }
}

