/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture.gui.theme;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.lib.zlib.json.serapi.Jsonable;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import javax.imageio.ImageIO;

public class GuiTheme
implements Jsonable {
    public static final List<GuiTheme> THEMES = new ArrayList<GuiTheme>();
    public static GuiTheme CURRENT_THEME;
    public final String name;
    public int bodyCover = 0;
    public int bodyLayerLU = 0xFFFFFF;
    public int bodyLayerRD = 0x555555;
    public int bodyColor = 0xC6C6C6;
    public int slotCoverLU = 0xFFFFFF;
    public int slotCoverRD = 0x373737;
    public int slotColor = 0x8B8B8B;
    public int textColor = 0xFFFFFF;
    public int textShadeColor = 0x555555;

    public static GuiTheme makeTheme(String theme) {
        try {
            InputStream in = HammerCore.class.getResourceAsStream("/assets/hammercore/themes/" + theme + ".png");
            GuiTheme t = GuiTheme.loadTheme(theme, ImageIO.read(in));
            in.close();
            if (!THEMES.stream().filter(h -> h.name.equalsIgnoreCase(t.name)).findFirst().isPresent()) {
                THEMES.add(t);
            }
            return t;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static GuiTheme getTheme(String id) {
        Optional<GuiTheme> th = THEMES.stream().filter(h -> h.name.equalsIgnoreCase(id)).findFirst();
        return th.isPresent() ? th.get() : null;
    }

    public GuiTheme(String name) {
        this.name = name;
    }

    public int size() {
        return 9;
    }

    private void applyColor(int id, int rgb) {
        if (id == 0) {
            this.bodyCover = rgb;
        }
        if (id == 1) {
            this.bodyLayerLU = rgb;
        }
        if (id == 2) {
            this.bodyLayerRD = rgb;
        }
        if (id == 3) {
            this.bodyColor = rgb;
        }
        if (id == 4) {
            this.slotCoverLU = rgb;
        }
        if (id == 5) {
            this.slotCoverRD = rgb;
        }
        if (id == 6) {
            this.slotColor = rgb;
        }
        if (id == 7) {
            this.textColor = rgb;
        }
        if (id == 8) {
            this.textShadeColor = rgb;
        }
    }

    public int getColor(int id) {
        if (id == 0) {
            return GuiTheme.setAlpha(this.bodyCover);
        }
        if (id == 1) {
            return GuiTheme.setAlpha(this.bodyLayerLU);
        }
        if (id == 2) {
            return GuiTheme.setAlpha(this.bodyLayerRD);
        }
        if (id == 3) {
            return GuiTheme.setAlpha(this.bodyColor);
        }
        if (id == 4) {
            return GuiTheme.setAlpha(this.slotCoverLU);
        }
        if (id == 5) {
            return GuiTheme.setAlpha(this.slotCoverRD);
        }
        if (id == 6) {
            return GuiTheme.setAlpha(this.slotColor);
        }
        if (id == 7) {
            return GuiTheme.setAlpha(this.textColor);
        }
        if (id == 8) {
            return GuiTheme.setAlpha(this.textShadeColor);
        }
        return -1;
    }

    public static GuiTheme current() {
        return CURRENT_THEME;
    }

    public static int setAlpha(int col) {
        return 0xFF000000 | col;
    }

    public BufferedImage exportTheme() {
        BufferedImage img = new BufferedImage(3, 4, 2);
        img.setRGB(0, 0, this.getColor(0));
        img.setRGB(0, 1, this.getColor(1));
        img.setRGB(0, 2, this.getColor(2));
        img.setRGB(0, 3, this.getColor(3));
        img.setRGB(1, 0, this.getColor(4));
        img.setRGB(1, 1, this.getColor(5));
        img.setRGB(1, 2, this.getColor(6));
        img.setRGB(2, 0, this.getColor(7));
        img.setRGB(2, 1, this.getColor(8));
        return img;
    }

    public void importTheme(BufferedImage img) {
        this.applyColor(0, img.getRGB(0, 0));
        this.applyColor(1, img.getRGB(0, 1));
        this.applyColor(2, img.getRGB(0, 2));
        this.applyColor(3, img.getRGB(0, 3));
        this.applyColor(4, img.getRGB(1, 0));
        this.applyColor(5, img.getRGB(1, 1));
        this.applyColor(6, img.getRGB(1, 2));
        this.applyColor(7, img.getRGB(2, 0));
        this.applyColor(8, img.getRGB(2, 1));
    }

    public static GuiTheme createTheme(String name, int ... colors) {
        GuiTheme t = new GuiTheme(name);
        for (int i = 0; i < colors.length; ++i) {
            t.applyColor(i, colors[i]);
        }
        return t;
    }

    public static GuiTheme loadTheme(String name, BufferedImage colors) {
        GuiTheme t = new GuiTheme(name);
        t.importTheme(colors);
        return t;
    }

    static {
        Scanner sc = new Scanner(HammerCore.class.getResourceAsStream("/assets/hammercore/themes/themes.txt"));
        while (sc.hasNext()) {
            GuiTheme.makeTheme(sc.next());
        }
        sc.close();
        CURRENT_THEME = GuiTheme.getTheme("Vanilla");
    }
}

