/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.objl;

import com.zeitheron.hammercore.lib.objl.OBJLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Model {
    public static final Logger LOGGER = LogManager.getLogger();
    public float[] vertices;
    public float[] texCoords;
    public float[] normals;
    public VerticesDescriptor[] vd;
    public float minX;
    public float maxX;
    public float minY;
    public float maxY;
    public float minZ;
    public float maxZ;
    public int POLY_TYPE_TRIANGLES = 0;
    public int POLY_TYPE_QUADS = 1;
    public int POLY_TYPE_POLYGON = 2;
    public OBJLoader loader = new OBJLoader(this);

    public Model(InputStream obj) {
        try {
            this.loader.load(new BufferedReader(new InputStreamReader(obj)));
        }
        catch (IOException e) {
            LOGGER.error("IOException >> Error loading model: " + e);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Exception >> Error loading model: " + e);
        }
    }

    public void cleanup() {
        this.loader.faces.clear();
        this.loader.facesnorms.clear();
        this.loader.facestexs.clear();
        this.loader.vertexsets.clear();
        this.loader.vertexsetsnorms.clear();
        this.loader.vertexsetstexs.clear();
    }

    public void convertToFloatArrays(boolean isMakeNormalsArray, boolean isMakeTexCoordsArray) {
        this.loader.convertToArrays(isMakeNormalsArray, isMakeTexCoordsArray);
    }

    public void enable(int funct) {
        if (funct == 0) {
            this.loader.texA = 1;
        } else if (funct == 1 || funct == 2) {
            this.loader.TEX_MODE = funct;
        }
    }

    public void disable(int funct) {
        if (funct == 0) {
            this.loader.texA = 0;
        } else {
            System.out.println("Can't disable this function");
        }
    }

    public void setDefaultPolyTypes(int POLY_TYPE_TRIANGLES, int POLY_TYPE_QUADS, int POLY_TYPE_POLYGON) {
        this.POLY_TYPE_TRIANGLES = POLY_TYPE_TRIANGLES;
        this.POLY_TYPE_QUADS = POLY_TYPE_QUADS;
        this.POLY_TYPE_POLYGON = POLY_TYPE_POLYGON;
    }

    public static class VerticesDescriptor {
        public static final int UNDEFINED_POLY_TYPE = -1;
        public int POLYTYPE = -1;
        public int START = 0;
        public int END = 0;
    }
}

