/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MainThreaded
public class PacketParticle
implements IPacket {
    public int world;
    public Vec3d pos;
    public Vec3d motion;
    public EnumParticleTypes particle;
    public int[] params;

    public PacketParticle(World world, EnumParticleTypes particle, Vec3d pos, Vec3d motion, int ... params) {
        this.world = world.field_73011_w.getDimension();
        this.pos = pos;
        this.motion = motion;
        this.particle = particle;
        this.params = params;
    }

    public PacketParticle() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("p0", this.particle.ordinal());
        nbt.func_74768_a("p1", this.world);
        nbt.func_74780_a("p2", this.pos.field_72450_a);
        nbt.func_74780_a("p3", this.pos.field_72448_b);
        nbt.func_74780_a("p4", this.pos.field_72449_c);
        nbt.func_74780_a("p5", this.motion.field_72450_a);
        nbt.func_74780_a("p6", this.motion.field_72448_b);
        nbt.func_74780_a("p7", this.motion.field_72449_c);
        nbt.func_74783_a("p8", this.params);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.particle = EnumParticleTypes.values()[nbt.func_74762_e("p0")];
        this.world = nbt.func_74762_e("p1");
        this.pos = new Vec3d(nbt.func_74769_h("p2"), nbt.func_74769_h("p3"), nbt.func_74769_h("p4"));
        this.motion = new Vec3d(nbt.func_74769_h("p5"), nbt.func_74769_h("p6"), nbt.func_74769_h("p7"));
        this.params = nbt.func_74759_k("p8");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IPacket executeOnClient(PacketContext net) {
        WorldClient wc = Minecraft.func_71410_x().field_71441_e;
        if (wc == null || this.world != wc.field_73011_w.getDimension()) {
            return null;
        }
        wc.func_175688_a(this.particle, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, this.motion.field_72450_a, this.motion.field_72448_b, this.motion.field_72449_c, this.params);
        return null;
    }

    static {
        IPacket.handle(PacketParticle.class, PacketParticle::new);
    }
}

