/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.utils.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public class FluidEnergyAccessPoint {
    World world;
    BlockPos pos;

    public FluidEnergyAccessPoint(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public static FluidEnergyAccessPoint create(World world, BlockPos pos) {
        return new FluidEnergyAccessPoint(world, pos);
    }

    public List<IEnergyStorage> findFEAcceptors() {
        ArrayList<IEnergyStorage> list = new ArrayList<IEnergyStorage>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos apos = this.pos.func_177972_a(face);
            TileEntity tile = this.world.func_175625_s(apos);
            if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) continue;
            list.add((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d()));
        }
        list.removeIf(es -> es == null || !es.canReceive());
        return list;
    }

    public List<IFluidHandler> findFLAcceptors(FluidStack fluid) {
        ArrayList<IFluidHandler> list = new ArrayList<IFluidHandler>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos apos = this.pos.func_177972_a(face);
            IFluidHandler ifh = FluidUtil.getFluidHandler((World)this.world, (BlockPos)apos, (EnumFacing)face.func_176734_d());
            if (ifh instanceof FluidBlockWrapper || ifh instanceof BlockLiquidWrapper || ifh == null || !FluidHelper.canAccept(ifh, fluid)) continue;
            list.add(ifh);
        }
        return list;
    }

    public int emitFluid(FluidStack fluid) {
        if (fluid == null) {
            return 0;
        }
        List<IFluidHandler> list = this.findFLAcceptors(fluid);
        if (list.isEmpty()) {
            return 0;
        }
        int per = fluid.amount / list.size();
        int quant = 0;
        for (int i = 0; i < list.size(); ++i) {
            IFluidHandler ies = list.get(i);
            int accepted = ies.fill(fluid.copy(), true);
            fluid.amount -= accepted;
            if (accepted < per && i != list.size() - 1) {
                per = fluid.amount / (list.size() - i - 1);
            }
            quant += accepted;
        }
        return quant;
    }

    public int emitEnergy(int FE) {
        List<IEnergyStorage> list = this.findFEAcceptors();
        if (list.isEmpty()) {
            return 0;
        }
        int ffe = FE;
        int per = FE / list.size();
        int quant = 0;
        for (int i = 0; i < list.size(); ++i) {
            IEnergyStorage ies = list.get(i);
            int accepted = ies.receiveEnergy(per, false);
            FE -= accepted;
            if (accepted < per && i != list.size() - 1) {
                per = FE / (list.size() - i - 1);
            }
            quant += accepted;
        }
        return quant;
    }
}

