/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.CoFHCore;
import cofh.core.command.ISubCommand;
import cofh.core.init.CoreProps;
import com.google.common.base.Throwables;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandTPS
implements ISubCommand {
    public static final CommandTPS INSTANCE = new CommandTPS();
    public static int permissionLevel = 0;
    private static DecimalFormat floatfmt = new DecimalFormat("##0.00");

    public static void config() {
        String category = "Command." + INSTANCE.getCommandName();
        String comment = "Adjust this value to change the default permission level for the " + INSTANCE.getCommandName() + " command.";
        permissionLevel = CoFHCore.CONFIG_CORE.getConfiguration().getInt("PermissionLevel", category, permissionLevel, -1, 4, comment);
    }

    private double getTickTimeSum(long[] times) {
        long timesum = 0L;
        if (times == null) {
            return 0.0;
        }
        for (long time : times) {
            timesum += time;
        }
        return timesum / (long)times.length;
    }

    private double getTickMs(World world) {
        return this.getTickTimeSum(world == null ? CoreProps.server.field_71311_j : (long[])CoreProps.server.worldTickTimes.get(world.field_73011_w.getDimension())) * 1.0E-6;
    }

    private double getTps(World world) {
        double tps = 1000.0 / this.getTickMs(world);
        return tps > 20.0 ? 20.0 : tps;
    }

    @Override
    public String getCommandName() {
        return "tps";
    }

    @Override
    public int getPermissionLevel() {
        return permissionLevel;
    }

    @Override
    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] arguments) throws CommandException {
        if (arguments.length < 2) {
            double tps = this.getTps(null);
            double tickms = this.getTickMs(null);
            sender.func_145747_a((ITextComponent)new TextComponentString("Overall: " + floatfmt.format(tps) + " TPS/" + floatfmt.format(tickms) + "MS (" + (int)(tps / 20.0 * 100.0) + "%)"));
            for (WorldServer world : CoreProps.server.field_71305_c) {
                tps = this.getTps((World)world);
                tickms = this.getTickMs((World)world);
                sender.func_145747_a((ITextComponent)new TextComponentString(world.field_73011_w.func_186058_p().func_186065_b() + " [" + world.field_73011_w.getDimension() + "]: " + floatfmt.format(tps) + " TPS/" + floatfmt.format(tickms) + "MS (" + (int)(tps / 20.0 * 100.0) + "%)"));
            }
        } else if (arguments[1].toLowerCase(Locale.US).charAt(0) == 'o') {
            double tickms = this.getTickMs(null);
            double tps = this.getTps(null);
            sender.func_145747_a((ITextComponent)new TextComponentString("Overall server tick"));
            sender.func_145747_a((ITextComponent)new TextComponentString("TPS: " + floatfmt.format(tps) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)"));
            sender.func_145747_a((ITextComponent)new TextComponentString("Tick time: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms"));
        } else if (arguments[1].toLowerCase(Locale.US).charAt(0) == 'a') {
            double tickms = this.getTickMs(null);
            double tps = this.getTps(null);
            sender.func_145747_a((ITextComponent)new TextComponentString("Overall server tick"));
            sender.func_145747_a((ITextComponent)new TextComponentString("TPS: " + floatfmt.format(tps) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)"));
            sender.func_145747_a((ITextComponent)new TextComponentString("Tick time: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms"));
            int loadedChunks = 0;
            int entities = 0;
            int te = 0;
            int worlds = 0;
            for (WorldServer world : CoreProps.server.field_71305_c) {
                loadedChunks += world.func_72863_F().func_73152_e();
                entities += world.field_72996_f.size();
                te += world.field_147482_g.size();
                ++worlds;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Total Loaded Worlds/Chunks: " + worlds + "/" + loadedChunks));
            sender.func_145747_a((ITextComponent)new TextComponentString("Total Entities/TileEntities: " + entities + "/" + te));
        } else {
            int dim = 0;
            try {
                dim = CommandBase.func_175755_a((String)arguments[1]);
            }
            catch (Throwable e) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.command.syntaxError", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
                Throwables.propagate((Throwable)e);
            }
            WorldServer world = CoreProps.server.func_71218_a(dim);
            if (world == null) {
                throw new CommandException("chat.cofh.command.world.notFound", new Object[0]);
            }
            double tickms = this.getTickMs((World)world);
            double tps = this.getTps((World)world);
            sender.func_145747_a((ITextComponent)new TextComponentString("World " + world.field_73011_w.getDimension() + ": " + world.field_73011_w.func_186058_p().func_186065_b() + " - Loaded chunks: " + world.func_72863_F().func_73152_e()));
            sender.func_145747_a((ITextComponent)new TextComponentString("TPS: " + floatfmt.format(tps) + "/" + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%) - Tick: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms"));
            sender.func_145747_a((ITextComponent)new TextComponentString("Entities: " + world.field_72996_f.size() + " - Tile entities: " + world.field_147482_g.size()));
        }
    }

    @Override
    public List<String> addTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> worldIDs = new ArrayList<String>();
            worldIDs.add("o");
            worldIDs.add("a");
            for (WorldServer world : CoreProps.server.field_71305_c) {
                worldIDs.add(Integer.toString(world.field_73011_w.getDimension()));
            }
            return CommandBase.func_71530_a((String[])args, (String[])worldIDs.toArray(new String[]{""}));
        }
        return null;
    }
}

