/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.inventory;

import cubex2.cxlibrary.inventory.ContainerCX;
import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.inventory.SlotFuel;
import cubex2.mods.morefurnaces.inventory.SlotInput;
import cubex2.mods.morefurnaces.inventory.SlotOutput;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ContainerIronFurnace
extends ContainerCX {
    private FurnaceType type;
    private EntityPlayer player;
    private TileEntityIronFurnace furnace;
    private int[] lastCookTime;
    private int lastBurnTime = 0;
    private int lastItemBurnTime = 0;

    public ContainerIronFurnace(InventoryPlayer invPlayer, TileEntityIronFurnace invFurnace, FurnaceType type) {
        int i;
        this.furnace = invFurnace;
        this.player = invPlayer.field_70458_d;
        this.type = type;
        this.lastCookTime = new int[type.parallelSmelting];
        int slotId = 0;
        for (i = 0; i < type.getNumInputSlots(); ++i) {
            this.func_75146_a((Slot)new SlotInput("furnace", (IItemHandler)invFurnace.getItemHandler(), slotId++));
        }
        for (i = 0; i < type.getNumFuelSlots(); ++i) {
            this.func_75146_a((Slot)new SlotFuel("furnace", invFurnace.getItemHandler(), slotId++));
        }
        for (i = 0; i < type.getNumOutputSlots(); ++i) {
            this.func_75146_a((Slot)new SlotOutput("furnace", this.player, (IItemHandlerModifiable)invFurnace.getItemHandler(), slotId++));
        }
        this.addPlayerSlots(invPlayer);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            for (int i = 0; i < this.type.parallelSmelting; ++i) {
                if (this.lastCookTime[i] == this.furnace.furnaceCookTime[i]) continue;
                listener.func_71112_a((Container)this, i, this.furnace.furnaceCookTime[i]);
            }
            if (this.lastBurnTime != this.furnace.furnaceBurnTime) {
                listener.func_71112_a((Container)this, this.type.parallelSmelting, this.furnace.furnaceBurnTime);
            }
            if (this.lastItemBurnTime == this.furnace.currentItemBurnTime) continue;
            listener.func_71112_a((Container)this, this.type.parallelSmelting + 1, this.furnace.currentItemBurnTime);
        }
        System.arraycopy(this.furnace.furnaceCookTime, 0, this.lastCookTime, 0, this.type.parallelSmelting);
        this.lastBurnTime = this.furnace.furnaceBurnTime;
        this.lastItemBurnTime = this.furnace.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int j) {
        if (i < this.type.parallelSmelting) {
            this.furnace.furnaceCookTime[i] = j;
        }
        if (i == this.type.parallelSmelting) {
            this.furnace.furnaceBurnTime = j;
        }
        if (i == this.type.parallelSmelting + 1) {
            this.furnace.currentItemBurnTime = j;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        BlockPos pos = this.furnace.func_174877_v();
        return player.field_70170_p.func_175625_s(pos) == this.furnace && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    private boolean isOutputSlot(int i) {
        return i >= this.type.getFirstOutputSlot(0) && i <= this.type.getLastOutputSlot(this.type.parallelSmelting - 1);
    }

    private boolean isInputSlot(int i) {
        return i >= this.type.getFirstInputSlot(0) && i <= this.type.getLastInputSlot(this.type.parallelSmelting - 1);
    }

    private boolean isFuelSlot(int i) {
        return i >= this.type.getFirstFuelSlot() && i <= this.type.getLastFuelSlot();
    }

    protected boolean transferStackInSlot(Slot slot, int index, ItemStack stack1, ItemStack stack) {
        if (this.isOutputSlot(index)) {
            if (!this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 36, true)) {
                return true;
            }
            slot.func_75220_a(stack1, stack);
        } else if (!this.isInputSlot(index) && !this.isFuelSlot(index) ? (!FurnaceRecipes.func_77602_a().func_151395_a(stack1).func_190926_b() ? !this.func_75135_a(stack1, 0, this.type.getFirstFuelSlot(), false) : (TileEntityFurnace.func_145954_b((ItemStack)stack1) ? !this.func_75135_a(stack1, this.type.getFirstFuelSlot(), this.type.getFirstOutputSlot(0), false) : (index >= this.type.getNumSlots() && index < this.type.getNumSlots() + 27 ? !this.func_75135_a(stack1, this.type.getNumSlots() + 27, this.type.getNumSlots() + 36, false) : index >= this.type.getNumSlots() + 27 && index < this.type.getNumSlots() + 36 && !this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 27, false)))) : !this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 36, false)) {
            return true;
        }
        return false;
    }
}

