/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import morph.avaritia.handler.ConfigHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.extreme.ExtremeShapelessRecipe;
import morph.avaritia.util.Lumberjack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.logging.log4j.Level;

public class FoodRecipes {
    private static final String[] sacredCropNames = new String[]{"cropWheat", "cropCarrot", "cropBeetroot", "cropPotato", "cropApple", "cropMelon", "cropPumpkin", "cropCactus", "cropMushroomRed", "cropMushroomBrown", "cropCherry"};
    private static final String[] forbiddenCropNames = new String[]{"cropEdibleroot", "cropWhitemushroom", "CropBeet", "cropCotton", "cropPoppy", "cropTulipRed", "cropTulipWhite", "cropDaisy", "cropTulipPink", "cropAllium", "cropOrchid", "cropTulipOrange", "cropDandelion", "cropShroomRed", "cropShroomBrown", "cropFerranium", "cropAurigold", "cropDiamahlia", "cropLapender", "cropEmeryllis", "cropRedstodendron", "cropCuprosia", "cropPetinia", "cropPlombean", "cropSilverweed", "cropJaslumine", "cropNiccissus", "cropPlatiolus", "cropOsmonium", "cropSandPear", "cropCitron"};
    private static final String[] knownMeatEntries = new String[]{"ingotMeatRaw", "dustMeat", "rawMutton"};
    private static List<ItemStack> knownMeats = new ArrayList<ItemStack>();
    private static Random randy;

    public static void initFoodRecipes() {
        int j;
        if (ConfigHandler.boringFood) {
            ArrayList<Ingredient> ings = new ArrayList<Ingredient>();
            ings.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151015_O, 1)}));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151172_bF));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151174_bG));
            ings.add(Ingredient.func_193367_a((Item)Items.field_185164_cV));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151034_e));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151127_ba));
            ings.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150423_aK)}));
            ings.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Blocks.field_150434_aF)}));
            ings.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Blocks.field_150337_Q)}));
            ings.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P)}));
            NonNullList n_ings = NonNullList.func_191196_a();
            n_ings.addAll(ings);
            ExtremeShapelessRecipe recipe = new ExtremeShapelessRecipe((NonNullList<Ingredient>)n_ings, new ItemStack((Item)ModItems.ultimate_stew, 1));
            recipe.setRegistryName(new ResourceLocation("avaritia", "ultimate_stew"));
            AvaritiaRecipeManager.EXTREME_RECIPES.put(recipe.getRegistryName(), recipe);
            ings.clear();
            ings.add(Ingredient.func_193367_a((Item)Items.field_151082_bd));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151082_bd));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151076_bf));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151076_bf));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151147_al));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151147_al));
            ings.add(Ingredient.func_193367_a((Item)Items.field_179558_bo));
            ings.add(Ingredient.func_193367_a((Item)Items.field_179558_bo));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151115_aP));
            ings.add(Ingredient.func_193367_a((Item)Items.field_151115_aP));
            n_ings = NonNullList.func_191196_a();
            n_ings.addAll(ings);
            recipe = new ExtremeShapelessRecipe((NonNullList<Ingredient>)n_ings, new ItemStack((Item)ModItems.cosmic_meatballs, 1));
            recipe.setRegistryName(new ResourceLocation("avaritia", "cosmic_meatballs"));
            AvaritiaRecipeManager.EXTREME_RECIPES.put(recipe.getRegistryName(), recipe);
            return;
        }
        String[] oreNames = OreDictionary.getOreNames();
        ArrayList<String> rawCrops = new ArrayList<String>();
        ArrayList<String> crops = new ArrayList<String>();
        ArrayList<String> rawMeats = new ArrayList<String>();
        ArrayList<String> meats = new ArrayList<String>();
        for (String oreName : oreNames) {
            if (!oreName.startsWith("crop") || FoodRecipes.isBannedCrop(oreName) || oreName.startsWith("cropBotania")) continue;
            rawCrops.add(oreName);
        }
        for (String crop : sacredCropNames) {
            if (!rawCrops.contains(crop)) continue;
            rawCrops.remove(crop);
            crops.add(crop);
        }
        List<FoodInfo> cropSortingList = new ArrayList<FoodInfo>();
        randy = new Random(12345L);
        for (String rawCrop : rawCrops) {
            NonNullList ores = OreDictionary.getOres((String)rawCrop);
            if (ores.size() <= 0) continue;
            cropSortingList.add(new FoodInfo(rawCrop, ores.size()));
        }
        cropSortingList.sort((a, b) -> {
            if (a.count != b.count) {
                return b.count > a.count ? 1 : -1;
            }
            return a.orename.compareTo(b.orename);
        });
        Collections.shuffle(cropSortingList, randy);
        cropSortingList.sort((a, b) -> {
            if (a.count != b.count) {
                return b.count > a.count ? 1 : -1;
            }
            return 0;
        });
        if (cropSortingList.size() > 80 - crops.size()) {
            int shouldHave = 80 - crops.size();
            cropSortingList = cropSortingList.subList(0, shouldHave);
        }
        for (FoodInfo aCropSortingList : cropSortingList) {
            crops.add(aCropSortingList.orename);
        }
        int croptypes = crops.size();
        int cropmultiplier = 1;
        while (croptypes * cropmultiplier < 8) {
            ++cropmultiplier;
        }
        int makesstew = (int)Math.round((double)(croptypes * cropmultiplier) / 9.0);
        NonNullList stewInputs = NonNullList.func_191196_a();
        stewInputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ModItems.neutron_pile}));
        for (String crop : crops) {
            for (int j2 = 0; j2 < cropmultiplier; ++j2) {
                stewInputs.add((Object)new OreIngredient(crop));
            }
        }
        ExtremeShapelessRecipe stew_recipe = new ExtremeShapelessRecipe((NonNullList<Ingredient>)stewInputs, new ItemStack((Item)ModItems.ultimate_stew, makesstew));
        stew_recipe.setRegistryName(new ResourceLocation("avaritia", "ultimate_stew"));
        AvaritiaRecipeManager.EXTREME_RECIPES.put(stew_recipe.getRegistryName(), stew_recipe);
        List<FoodInfo> meatSortingList = new ArrayList<FoodInfo>();
        randy = new Random(54321L);
        for (String knownMeatEntry : knownMeatEntries) {
            Object meatstacks;
            if (!OreDictionary.doesOreNameExist((String)knownMeatEntry) || (meatstacks = OreDictionary.getOres((String)knownMeatEntry)).isEmpty()) continue;
            rawMeats.add(knownMeatEntry);
            meatSortingList.add(new FoodInfo(knownMeatEntry, meatstacks.size()));
        }
        Lumberjack.log(Level.INFO, "rawMeats: " + rawMeats);
        Lumberjack.log(Level.INFO, "knownMeats: " + knownMeats);
        meatSortingList.sort((a, b) -> {
            if (a.count != b.count) {
                return b.count > a.count ? 1 : -1;
            }
            return a.orename.compareTo(b.orename);
        });
        meatSortingList.sort((a, b) -> {
            if (a.count != b.count) {
                return b.count > a.count ? 1 : -1;
            }
            return randy.nextBoolean() ? 1 : -1;
        });
        if (meatSortingList.size() > 80 - meats.size() - knownMeats.size()) {
            int shouldHave = 80 - meats.size() - knownMeats.size();
            meatSortingList = meatSortingList.subList(0, shouldHave);
        }
        for (FoodInfo aMeatSortingList : meatSortingList) {
            meats.add(aMeatSortingList.orename);
        }
        int meattypes = meats.size() + knownMeats.size();
        int meatmultiplier = 1;
        while (meattypes * meatmultiplier < 8) {
            ++meatmultiplier;
        }
        int makesmeatballs = (int)Math.round((double)(meattypes * meatmultiplier) / 9.0);
        NonNullList meatballInputs = NonNullList.func_191196_a();
        meatballInputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ModItems.neutron_pile}));
        for (ItemStack knownMeat : knownMeats) {
            for (j = 0; j < meatmultiplier; ++j) {
                meatballInputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{knownMeat}));
            }
        }
        for (String meat : meats) {
            for (j = 0; j < meatmultiplier; ++j) {
                meatballInputs.add((Object)new OreIngredient(meat));
            }
        }
        ExtremeShapelessRecipe metaball_recipe = new ExtremeShapelessRecipe((NonNullList<Ingredient>)meatballInputs, new ItemStack((Item)ModItems.cosmic_meatballs, makesmeatballs));
        metaball_recipe.setRegistryName(new ResourceLocation("avaritia", "cosmic_meatballs"));
        AvaritiaRecipeManager.EXTREME_RECIPES.put(metaball_recipe.getRegistryName(), metaball_recipe);
    }

    private static boolean isBannedCrop(String crop) {
        for (String ban : forbiddenCropNames) {
            if (!ban.equals(crop)) continue;
            return true;
        }
        return false;
    }

    static {
        knownMeats.add(new ItemStack(Items.field_151082_bd));
        knownMeats.add(new ItemStack(Items.field_151076_bf));
        knownMeats.add(new ItemStack(Items.field_151147_al));
        knownMeats.add(new ItemStack(Items.field_179558_bo));
        knownMeats.add(new ItemStack(Items.field_151115_aP));
        OreDictionary.registerOre((String)"cropCactus", (ItemStack)new ItemStack((Block)Blocks.field_150434_aF));
        OreDictionary.registerOre((String)"cropMushroomRed", (ItemStack)new ItemStack((Block)Blocks.field_150337_Q));
        OreDictionary.registerOre((String)"cropMushroomBrown", (ItemStack)new ItemStack((Block)Blocks.field_150338_P));
    }

    private static class FoodInfo {
        public final String orename;
        public final int count;

        public FoodInfo(String orename, int count) {
            this.orename = orename;
            this.count = count;
        }

        public String toString() {
            return this.orename + ": " + this.count;
        }
    }
}

