/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.init;

import java.util.function.Consumer;
import morph.avaritia.Avaritia;
import morph.avaritia.api.registration.IModelRegister;
import morph.avaritia.block.BlockCompressedCraftingTable;
import morph.avaritia.block.BlockDoubleCompressedCraftingTable;
import morph.avaritia.block.BlockExtremeCraftingTable;
import morph.avaritia.block.BlockNeutronCollector;
import morph.avaritia.block.BlockNeutroniumCompressor;
import morph.avaritia.block.BlockResource;
import morph.avaritia.block.ItemBlockResource;
import morph.avaritia.tile.TileDireCraftingTable;
import morph.avaritia.tile.TileNeutronCollector;
import morph.avaritia.tile.TileNeutroniumCompressor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockCompressedCraftingTable compressedCraftingTable;
    public static BlockDoubleCompressedCraftingTable doubleCompressedCraftingTable;
    public static BlockExtremeCraftingTable extremeCraftingTable;
    public static BlockResource resource;
    public static BlockNeutronCollector neutron_collector;
    public static BlockNeutroniumCompressor neutronium_compressor;

    public static void init() {
        compressedCraftingTable = ModBlocks.registerBlock(new BlockCompressedCraftingTable());
        ModBlocks.registerItemBlock(compressedCraftingTable);
        doubleCompressedCraftingTable = ModBlocks.registerBlock(new BlockDoubleCompressedCraftingTable());
        ModBlocks.registerItemBlock(doubleCompressedCraftingTable);
        extremeCraftingTable = ModBlocks.registerBlock(new BlockExtremeCraftingTable());
        ModBlocks.registerItemBlock((Block)extremeCraftingTable);
        GameRegistry.registerTileEntity(TileDireCraftingTable.class, (String)"avaritia_extreme_crafting_table");
        resource = ModBlocks.registerBlock(new BlockResource());
        ModBlocks.registerItem(new ItemBlockResource(resource));
        neutron_collector = ModBlocks.registerBlock(new BlockNeutronCollector());
        ModBlocks.registerItemBlock((Block)neutron_collector);
        GameRegistry.registerTileEntity(TileNeutronCollector.class, (String)"neutron_collector");
        neutronium_compressor = ModBlocks.registerBlock(new BlockNeutroniumCompressor());
        ModBlocks.registerItemBlock((Block)neutronium_compressor);
        GameRegistry.registerTileEntity(TileNeutroniumCompressor.class, (String)"neutronium_compressor");
    }

    public static <V extends Block> V registerBlock(V block) {
        ModBlocks.registerImpl(block, arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).register(arg_0));
        return block;
    }

    public static <V extends Item> V registerItem(V item) {
        ModBlocks.registerImpl(item, arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).register(arg_0));
        return item;
    }

    public static <V extends IForgeRegistryEntry<V>> V registerImpl(V registryObject, Consumer<V> registerCallback) {
        registerCallback.accept(registryObject);
        if (registryObject instanceof IModelRegister) {
            Avaritia.proxy.addModelRegister((IModelRegister)registryObject);
        }
        return registryObject;
    }

    public static ItemBlock registerItemBlock(Block block) {
        ItemBlock itemBlock = new ItemBlock(block);
        ModBlocks.registerItem((Item)itemBlock.setRegistryName(block.getRegistryName()));
        return itemBlock;
    }
}

