/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe;

import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import morph.avaritia.recipe.IRecipeFactory;
import morph.avaritia.recipe.compressor.CompressorRecipe;
import morph.avaritia.recipe.compressor.ICompressorRecipe;
import morph.avaritia.recipe.extreme.ExtremeShapedRecipe;
import morph.avaritia.recipe.extreme.ExtremeShapelessRecipe;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import morph.avaritia.util.Lumberjack;
import morph.avaritia.util.TriConsumer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class AvaritiaRecipeManager {
    public static final Map<ResourceLocation, IExtremeRecipe> EXTREME_RECIPES = new HashMap<ResourceLocation, IExtremeRecipe>();
    public static final Map<ResourceLocation, ICompressorRecipe> COMPRESSOR_RECIPES = new HashMap<ResourceLocation, ICompressorRecipe>();
    private static final Map<ResourceLocation, IRecipeFactory<IExtremeRecipe>> extremeRecipeFactories = new HashMap<ResourceLocation, IRecipeFactory<IExtremeRecipe>>();
    private static final Map<ResourceLocation, IRecipeFactory<ICompressorRecipe>> compressorRecipeFactories = new HashMap<ResourceLocation, IRecipeFactory<ICompressorRecipe>>();
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ObfMapping mapping = new ObfMapping("net/minecraftforge/common/crafting/JsonContext", "loadConstants", "([Lcom/google/gson/JsonObject;)V");
    private static final BiConsumer<JsonContext, JsonObject[]> callLoadContext = (ctx, json) -> ReflectionManager.callMethod((ObfMapping)mapping, null, (Object)ctx, (Object[])new Object[]{json});

    public static void init() {
        extremeRecipeFactories.put(new ResourceLocation("avaritia:shaped"), ExtremeShapedRecipe::fromJson);
        extremeRecipeFactories.put(new ResourceLocation("avaritia:shapeless"), ExtremeShapelessRecipe::fromJson);
        compressorRecipeFactories.put(new ResourceLocation("avaritia:compressor"), CompressorRecipe::fromJson);
        Loader loader = Loader.instance();
        ModContainer me = loader.activeModContainer();
        loader.setActiveModContainer(null);
        loader.getActiveModList().forEach(AvaritiaRecipeManager::loadFactories);
        loader.getActiveModList().forEach(mod -> AvaritiaRecipeManager.loadRecipes(mod, "extreme", (json, ctx, key) -> {
            IExtremeRecipe recipe = (IExtremeRecipe)AvaritiaRecipeManager.getRecipe(json, ctx, extremeRecipeFactories::get);
            EXTREME_RECIPES.put((ResourceLocation)key, (IExtremeRecipe)recipe.setRegistryName((ResourceLocation)key));
        }));
        loader.getActiveModList().forEach(mod -> AvaritiaRecipeManager.loadRecipes(mod, "compressor", (json, ctx, key) -> {
            ICompressorRecipe recipe = (ICompressorRecipe)AvaritiaRecipeManager.getRecipe(json, ctx, compressorRecipeFactories::get);
            if (recipe != null) {
                recipe.setRegistryName((ResourceLocation)key);
                COMPRESSOR_RECIPES.put((ResourceLocation)key, recipe);
            }
        }));
        loader.setActiveModContainer(me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFactories(ModContainer mod) {
        BufferedReader reader;
        FileSystem fs;
        block8: {
            fs = null;
            reader = null;
            try {
                JsonObject json;
                JsonContext ctx = new JsonContext(mod.getModId());
                Path fPath = null;
                if (mod.getSource().isFile()) {
                    fs = FileSystems.newFileSystem(mod.getSource().toPath(), null);
                    fPath = fs.getPath("/assets/" + ctx.getModId() + "/avaritia_recipes/_factories.json", new String[0]);
                } else if (mod.getSource().isDirectory()) {
                    fPath = mod.getSource().toPath().resolve("assets/" + ctx.getModId() + "/avaritia_recipes/_factories.json");
                }
                if (fPath == null || !Files.exists(fPath, new LinkOption[0]) || !(json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)(reader = Files.newBufferedReader(fPath)), JsonObject.class)).has("extreme")) break block8;
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"extreme").entrySet()) {
                    ResourceLocation key = new ResourceLocation(ctx.getModId(), (String)entry.getKey());
                    String clazzName = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)("extreme[" + entry.getValue() + "]"));
                    extremeRecipeFactories.put(key, AvaritiaRecipeManager.newClass(clazzName, IRecipeFactory.class));
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable[])new Closeable[]{fs, reader});
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable[])new Closeable[]{fs, reader});
            }
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fs, reader});
    }

    private static void loadRecipes(ModContainer mod, String type, TriConsumer<JsonObject, JsonContext, ResourceLocation> loadRecipe) {
        JsonContext ctx = new JsonContext(mod.getModId());
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/avaritia_recipes/" + type), root -> {
            Path fPath = root.resolve("_constants.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(fPath);
                    JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject[].class);
                    callLoadContext.accept(ctx, json);
                }
                catch (IOException e) {
                    Lumberjack.log(Level.ERROR, e, (Object)"Error loading _constants.json: ");
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                if (json.has("conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)json, (String)"conditions"), (JsonContext)ctx)) {
                    Boolean bl = true;
                    return bl;
                }
                loadRecipe.accept(json, ctx, key);
            }
            catch (JsonParseException e) {
                Lumberjack.log(Level.ERROR, e, "Parsing error loading recipe %s", key);
                Boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                Lumberjack.log(Level.ERROR, e, "Couldn't read recipe %s from %s", key, file);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        });
    }

    private static <T> T getRecipe(JsonObject obj, JsonContext ctx, Function<ResourceLocation, IRecipeFactory<T>> getter) {
        if (obj == null || obj.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("getRecipe Context cannot be null");
        }
        String type = ctx.appendModId(JsonUtils.func_151200_h((JsonObject)obj, (String)"type"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Recipe type can not be an empty string");
        }
        IRecipeFactory<T> factory = getter.apply(new ResourceLocation(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown recipe type: " + type);
        }
        return factory.load(ctx, obj);
    }

    private static <T> T newClass(String name, Class<T> clazz) {
        try {
            ObfMapping mapping = new ObfMapping(name.replace(".", "/"), "", "()V");
            return (T)ReflectionManager.newInstance_Unsafe((ObfMapping)mapping, clazz, (Object[])new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonSyntaxException("Could not instantiate: " + name, (Throwable)e);
        }
    }

    public static ICompressorRecipe getCompressorRecipeFromInput(ItemStack input) {
        for (ICompressorRecipe recipe : COMPRESSOR_RECIPES.values()) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static ICompressorRecipe getCompressorRecipeFromResult(ItemStack result) {
        for (ICompressorRecipe recipe : COMPRESSOR_RECIPES.values()) {
            if (!recipe.getResult().func_77969_a(result)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean hasCompressorRecipe(ItemStack input) {
        return AvaritiaRecipeManager.getCompressorRecipeFromInput(input) != null;
    }

    public static boolean hasCompressorRecipe(ItemStack input, ItemStack output) {
        if (!input.func_190926_b()) {
            for (ICompressorRecipe recipe : COMPRESSOR_RECIPES.values()) {
                if (!recipe.matches(input) || !output.func_190926_b() && !recipe.getResult().func_77969_a(output)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getExtremeCraftingResult(InventoryCrafting matrix, World world) {
        for (IExtremeRecipe recipe : EXTREME_RECIPES.values()) {
            if (!recipe.matches(matrix, world)) continue;
            return recipe.getCraftingResult(matrix);
        }
        return ItemStack.field_190927_a;
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting matrix, World world) {
        for (IExtremeRecipe recipe : EXTREME_RECIPES.values()) {
            if (!recipe.matches(matrix, world)) continue;
            return recipe.getRemainingItems(matrix);
        }
        NonNullList stacks = NonNullList.func_191197_a((int)matrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.size(); ++i) {
            stacks.set(i, (Object)matrix.func_70301_a(i));
        }
        return stacks;
    }
}

