/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.api.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.api.code.IOpcodeRunnable;
import mcjty.rftoolscontrol.api.code.OpcodeCategory;
import mcjty.rftoolscontrol.api.code.OpcodeOutput;
import mcjty.rftoolscontrol.api.parameters.ParameterDescription;

public class Opcode {
    private final String id;
    private final OpcodeOutput opcodeOutput;
    private final boolean isEvent;
    private final List<ParameterDescription> parameters;
    private final String outputDescription;
    private final IOpcodeRunnable runnable;
    private final List<String> description;
    private final Set<OpcodeCategory> categories;
    private final boolean deprecated;
    private final int iconU;
    private final int iconV;
    private final String iconResource;

    private Opcode(Builder builder) {
        this.id = builder.id;
        this.opcodeOutput = builder.opcodeOutput;
        this.isEvent = builder.isEvent;
        this.parameters = new ArrayList<ParameterDescription>(builder.parameters);
        this.iconU = builder.iconU;
        this.iconV = builder.iconV;
        this.runnable = builder.runnable;
        this.description = new ArrayList<String>(builder.description);
        this.categories = EnumSet.copyOf(builder.categories);
        this.outputDescription = builder.outputDescription;
        this.deprecated = builder.deprecated;
        this.iconResource = builder.iconResource;
    }

    public String getId() {
        return this.id;
    }

    public OpcodeOutput getOpcodeOutput() {
        return this.opcodeOutput;
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    public Set<OpcodeCategory> getCategories() {
        return this.categories;
    }

    @Nonnull
    public List<ParameterDescription> getParameters() {
        return this.parameters;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Nonnull
    public IOpcodeRunnable getRunnable() {
        return this.runnable;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public String getOutputDescription() {
        return this.outputDescription;
    }

    public int getIconU() {
        return this.iconU;
    }

    public int getIconV() {
        return this.iconV;
    }

    @Nullable
    public String getIconResource() {
        return this.iconResource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Opcode opcode = (Opcode)o;
        return this.id.equals(opcode.id);
    }

    public String toString() {
        return "Opcode{" + this.id + '}';
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class Builder {
        private static final IOpcodeRunnable NOOP = (processor, program, opcode) -> IOpcodeRunnable.OpcodeResult.POSITIVE;
        private String id;
        private OpcodeOutput opcodeOutput = OpcodeOutput.SINGLE;
        private boolean isEvent = false;
        private int iconU;
        private int iconV;
        private String iconResource;
        private List<ParameterDescription> parameters = new ArrayList<ParameterDescription>();
        private IOpcodeRunnable runnable = NOOP;
        private List<String> description = Collections.emptyList();
        private String outputDescription = "No result";
        private Set<OpcodeCategory> categories = EnumSet.noneOf(OpcodeCategory.class);
        private boolean deprecated = false;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder description(String ... description) {
            this.description = new ArrayList<String>();
            Collections.addAll(this.description, description);
            return this;
        }

        public Builder outputDescription(String outputDescription) {
            this.outputDescription = outputDescription;
            return this;
        }

        public Builder runnable(IOpcodeRunnable runnable) {
            this.runnable = runnable;
            return this;
        }

        public Builder opcodeOutput(OpcodeOutput opcodeOutput) {
            this.opcodeOutput = opcodeOutput;
            return this;
        }

        public Builder isEvent(boolean isEvent) {
            this.isEvent = isEvent;
            return this;
        }

        public Builder icon(int u, int v) {
            this.iconU = u;
            this.iconV = v;
            return this;
        }

        public Builder icon(int u, int v, String iconLocation) {
            this.iconU = u;
            this.iconV = v;
            this.iconResource = iconLocation;
            return this;
        }

        public Builder category(OpcodeCategory category) {
            this.categories.add(category);
            return this;
        }

        public Builder parameter(ParameterDescription parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Opcode build() {
            return new Opcode(this);
        }
    }
}

