/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.programmer;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.icons.IIcon;
import mcjty.lib.gui.icons.ImageIcon;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.IconHolder;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.api.code.Opcode;
import mcjty.rftoolscontrol.api.code.OpcodeCategory;
import mcjty.rftoolscontrol.api.code.OpcodeOutput;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterDescription;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.blocks.programmer.PacketUpdateNBTItemInventoryProgrammer;
import mcjty.rftoolscontrol.blocks.programmer.ProgrammerContainer;
import mcjty.rftoolscontrol.blocks.programmer.ProgrammerTileEntity;
import mcjty.rftoolscontrol.config.ConfigSetup;
import mcjty.rftoolscontrol.gui.GuiTools;
import mcjty.rftoolscontrol.items.ProgramCardItem;
import mcjty.rftoolscontrol.logic.Connection;
import mcjty.rftoolscontrol.logic.ParameterTypeTools;
import mcjty.rftoolscontrol.logic.compiled.ProgramValidator;
import mcjty.rftoolscontrol.logic.editors.ParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditors;
import mcjty.rftoolscontrol.logic.grid.GridInstance;
import mcjty.rftoolscontrol.logic.grid.GridPos;
import mcjty.rftoolscontrol.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import mcjty.rftoolscontrol.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class GuiProgrammer
extends GenericGuiContainer<ProgrammerTileEntity> {
    public static final int SIDEWIDTH = 80;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 236;
    public static final int GRID_HEIGHT = 10;
    public static final int GRID_WIDTH = 11;
    public static int ICONSIZE = 20;
    private static final ResourceLocation mainBackground = new ResourceLocation("rftoolscontrol", "textures/gui/programmer.png");
    private static final ResourceLocation sideBackground = new ResourceLocation("rftoolscontrol", "textures/gui/sidegui.png");
    private static final ResourceLocation icons = new ResourceLocation("rftoolscontrol", "textures/gui/icons.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolscontrol", "textures/gui/guielements.png");
    private Window sideWindow;
    private WidgetList gridList;
    private WidgetList editorList;
    private WidgetList opcodeList;
    private IconHolder trashcan;
    private List<ImageChoiceLabel> categoryLabels = new ArrayList<ImageChoiceLabel>();
    private int iconLeavesFromX = -1;
    private int iconLeavesFromY = -1;
    private boolean loading = false;
    private OpcodeCategory currentCategory = null;
    private static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private static final Map<Connection, IIcon> CONNECTION_ICONS = new HashMap<Connection, IIcon>();
    private static final Map<Connection, IIcon> HIGHLIGHT_ICONS = new HashMap<Connection, IIcon>();
    private static final IIcon selectionIcon;
    private static final IIcon errorIcon1;
    private static final IIcon errorIcon2;
    private static ProgramCardInstance undoProgram;
    private GridPos prevHighlightConnector = null;
    private long prevTime = -1L;
    private int saveCounter = 10;

    public GuiProgrammer(ProgrammerTileEntity tileEntity, ProgrammerContainer container) {
        super((ModBase)RFToolsControl.instance, RFToolsCtrlMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, GuiProxy.GUI_MANUAL_CONTROL, "programmer");
        this.field_146999_f = 256;
        this.field_147000_g = 236;
        this.initIcons();
    }

    private void initIcons() {
        if (ICONS.isEmpty()) {
            for (Map.Entry<String, Opcode> entry : Opcodes.OPCODES.entrySet()) {
                String id = entry.getKey();
                Opcode opcode = entry.getValue();
                ResourceLocation iconResource = icons;
                if (opcode.getIconResource() != null) {
                    iconResource = new ResourceLocation(opcode.getIconResource());
                }
                ICONS.put(id, (IIcon)new ImageIcon(id).setDimensions(ICONSIZE, ICONSIZE).setImage(iconResource, opcode.getIconU() * ICONSIZE, opcode.getIconV() * ICONSIZE));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel editorPanel = this.setupEditorPanel();
        Panel controlPanel = this.setupControlPanel();
        Panel gridPanel = this.setupGridPanel();
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(mainBackground)).addChild((Widget)editorPanel)).addChild((Widget)controlPanel)).addChild((Widget)gridPanel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel).addFocusEvent((parent, focused) -> this.selectIcon(parent, focused));
        Panel listPanel = this.setupListPanel();
        Panel sidePanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(sideBackground)).addChild((Widget)listPanel);
        sidePanel.setBounds(new Rectangle(this.field_147003_i - 80, this.field_147009_r, 80, this.field_147000_g));
        this.sideWindow = new Window((GuiScreen)this, (AbstractContainerWidget)sidePanel);
        this.loadProgram(1);
        this.clearCategoryLabels();
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
        mgr.getIconManager().setClickHoldToDrag(true);
    }

    private Panel setupGridPanel() {
        Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 246, 130));
        this.gridList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("grid")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 236, 130))).setPropagateEventsToChildren(true).setInvisibleSelection(true).setDrawHorizontalLines(false).setRowheight(ICONSIZE + 1);
        Slider slider = (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollableName("grid").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(237, 0, 9, 130));
        for (int y = 0; y < 10; ++y) {
            Panel rowPanel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)((HorizontalLayout)new HorizontalLayout().setSpacing(-1)).setHorizontalMargin(0)).setVerticalMargin(0));
            int x = 0;
            while (x < 11) {
                final int finalX = x++;
                final int finalY = y;
                IconHolder holder = ((IconHolder)((IconHolder)((IconHolder)new IconHolder(this.field_146297_k, (Gui)this){

                    public List<String> getTooltips() {
                        return GuiProgrammer.this.getGridIconTooltips(finalX, finalY);
                    }
                }.setDesiredWidth(ICONSIZE + 2)).setDesiredHeight(ICONSIZE + 2)).setBorder(1).setBorderColor(Integer.valueOf(-8947849)).setSelectable(true).setUserObject((Object)new GridPos(finalX, finalY))).addIconHoverEvent((iconHolder, iIcon, dx, dy) -> this.handleConnectorHighlight(finalX, finalY, iIcon, dx, dy)).addIconLeavesEvent((parent, icon) -> {
                    this.iconLeavesFromX = finalX;
                    this.iconLeavesFromY = finalY;
                    return true;
                }).addIconArrivesEvent((parent, icon) -> {
                    if (icon != null && !this.loading) {
                        this.handleNewIconOverlay(icon, finalX, finalY);
                    }
                    return true;
                }).addIconClickedEvent((parent, icon, dx, dy) -> {
                    this.gridIconClicked(icon, finalX, finalY, dx, dy);
                    return true;
                });
                rowPanel.addChild((Widget)holder);
            }
            this.gridList.addChild((Widget)rowPanel);
        }
        ((Panel)panel.addChild((Widget)this.gridList)).addChild((Widget)slider);
        return panel;
    }

    private List<String> getGridIconTooltips(int finalX, int finalY) {
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (ConfigSetup.tooltipVerbosityLevel.get() >= 2) {
                tooltips.add(TextFormatting.GREEN + "Ctrl-Click to add or remove selection");
                tooltips.add(TextFormatting.GREEN + "Ctrl-Double click to (de)select sequence");
                tooltips.add(TextFormatting.YELLOW + "Ctrl-A to select entire grid");
                tooltips.add(TextFormatting.YELLOW + "Ctrl-C to copy selected grid");
                tooltips.add(TextFormatting.YELLOW + "Ctrl-X to cut selected grid");
                tooltips.add(TextFormatting.YELLOW + "Ctrl-V to paste to selected grid");
                tooltips.add(TextFormatting.YELLOW + "Ctrl-Z undo last paste operation");
            } else if (ConfigSetup.tooltipVerbosityLevel.get() >= 1) {
                tooltips.add(TextFormatting.GREEN + "Use Ctrl with A, C, X, V or Z");
            }
            return tooltips;
        }
        if (this.prevHighlightConnector != null) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (ConfigSetup.doubleClickToChangeConnector.get()) {
                tooltips.add(TextFormatting.GREEN + "Double click to change connector");
            } else {
                tooltips.add(TextFormatting.GREEN + "Click to change connector");
            }
            return tooltips;
        }
        return this.getIconTooltipGrid(finalX, finalY);
    }

    private void selectSequence(GridPos pos, Set<GridPos> done, boolean select) {
        if (!this.checkValidGridPos(pos)) {
            return;
        }
        if (done.contains(pos)) {
            return;
        }
        IIcon icon = this.getHolder(pos.getX(), pos.getY()).getIcon();
        if (icon == null) {
            return;
        }
        icon.removeOverlay("S");
        if (select) {
            icon.addOverlay(selectionIcon);
        }
        done.add(pos);
        this.selectSequence(pos.up(), done, select);
        this.selectSequence(pos.down(), done, select);
        this.selectSequence(pos.left(), done, select);
        this.selectSequence(pos.right(), done, select);
    }

    private boolean checkValidGridPos(GridPos pos) {
        if (pos.getX() < 0 || pos.getX() >= 11) {
            return false;
        }
        return pos.getY() >= 0 && pos.getY() < 10;
    }

    private void gridIconClicked(IIcon icon, int x, int y, int dx, int dy) {
        Connection connection;
        boolean doubleclick;
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            long time = System.currentTimeMillis();
            boolean doubleclick2 = false;
            if (this.prevTime != -1L && time - this.prevTime < 250L) {
                doubleclick2 = true;
            }
            this.prevTime = time;
            if (icon.hasOverlay("S")) {
                if (doubleclick2) {
                    this.selectSequence(new GridPos(x, y), new HashSet<GridPos>(), true);
                } else {
                    icon.removeOverlay("S");
                }
            } else if (doubleclick2) {
                this.selectSequence(new GridPos(x, y), new HashSet<GridPos>(), false);
            } else {
                icon.addOverlay(selectionIcon);
            }
            return;
        }
        this.clearSelection();
        long time = System.currentTimeMillis();
        boolean bl = doubleclick = !ConfigSetup.doubleClickToChangeConnector.get();
        if (this.prevTime != -1L && time - this.prevTime < 250L) {
            doubleclick = true;
        }
        this.prevTime = time;
        if (doubleclick && (connection = this.getConnectionHandle(dx, dy)) != null) {
            this.handleIconOverlay(icon, connection);
        }
    }

    private void selectAll() {
        for (int ix = 0; ix < 11; ++ix) {
            for (int iy = 0; iy < 10; ++iy) {
                IIcon i = this.getHolder(ix, iy).getIcon();
                if (i == null) continue;
                i.addOverlay(selectionIcon);
            }
        }
    }

    private void clearSelection() {
        for (int ix = 0; ix < 11; ++ix) {
            for (int iy = 0; iy < 10; ++iy) {
                IIcon i = this.getHolder(ix, iy).getIcon();
                if (i == null) continue;
                i.removeOverlay("S");
            }
        }
    }

    private boolean checkSelection() {
        for (int ix = 0; ix < 11; ++ix) {
            for (int iy = 0; iy < 10; ++iy) {
                IIcon i = this.getHolder(ix, iy).getIcon();
                if (i == null || !i.hasOverlay("S")) continue;
                return true;
            }
        }
        return false;
    }

    private void handleConnectorHighlight(int finalX, int finalY, IIcon iIcon, int dx, int dy) {
        if (this.prevHighlightConnector != null) {
            IconHolder h = this.getHolder(this.prevHighlightConnector.getX(), this.prevHighlightConnector.getY());
            if (h.getIcon() != null) {
                h.getIcon().removeOverlay("H");
            }
            this.prevHighlightConnector = null;
        }
        if (iIcon == null) {
            return;
        }
        iIcon.removeOverlay("H");
        Connection connection = this.getConnectionHandle(dx, dy);
        if (connection != null) {
            iIcon.addOverlay(HIGHLIGHT_ICONS.get((Object)connection));
            this.prevHighlightConnector = new GridPos(finalX, finalY);
        }
    }

    private Connection getConnectionHandle(int dx, int dy) {
        if (dy <= 5 && dx >= 8 && dx <= 15) {
            return Connection.UP;
        }
        if (dy >= ICONSIZE - 3 && dx >= 8 && dx <= 15) {
            return Connection.DOWN;
        }
        if (dx <= 5 && dy >= 7 && dy <= 14) {
            return Connection.LEFT;
        }
        if (dx >= ICONSIZE - 3 && dy >= 7 && dy <= 14) {
            return Connection.RIGHT;
        }
        return null;
    }

    private void handleNewIconOverlay(IIcon icon, int x, int y) {
        if (x == this.iconLeavesFromX && y == this.iconLeavesFromY) {
            return;
        }
        Opcode opcode = Opcodes.OPCODES.get(icon.getID());
        if (opcode.isEvent()) {
            return;
        }
        this.tryConnectToThis(x - 1, y, icon, Connection.RIGHT);
        this.tryConnectToThis(x + 1, y, icon, Connection.LEFT);
        this.tryConnectToThis(x, y - 1, icon, Connection.DOWN);
        this.tryConnectToThis(x, y + 1, icon, Connection.UP);
    }

    private void tryConnectToThis(int x, int y, IIcon icon, Connection connection) {
        if (x < 0 || x >= 11) {
            return;
        }
        if (y < 0 || y >= 10) {
            return;
        }
        IconHolder holder = this.getHolder(x, y);
        IIcon sourceIcon = holder.getIcon();
        if (sourceIcon != null) {
            Opcode opcode = Opcodes.OPCODES.get(sourceIcon.getID());
            if (opcode.getOpcodeOutput() == OpcodeOutput.NONE) {
                return;
            }
            if (opcode.getOpcodeOutput() == OpcodeOutput.SINGLE) {
                int cnt = this.countConnections(sourceIcon);
                if (cnt == 0) {
                    sourceIcon.addOverlay(CONNECTION_ICONS.get((Object)connection));
                }
            } else if (opcode.getOpcodeOutput() == OpcodeOutput.YESNO) {
                int cnt = this.countPrimaryConnections(sourceIcon);
                if (cnt == 0) {
                    sourceIcon.addOverlay(CONNECTION_ICONS.get((Object)connection));
                } else {
                    cnt = this.countSecondaryConnections(sourceIcon);
                    if (cnt == 0) {
                        sourceIcon.addOverlay(CONNECTION_ICONS.get((Object)connection.getOpposite()));
                    }
                }
            }
        }
    }

    private int countConnections(IIcon sourceIcon) {
        int cnt = 0;
        for (Connection connection : Connection.values()) {
            if (!sourceIcon.hasOverlay(connection.getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    private int countPrimaryConnections(IIcon sourceIcon) {
        int cnt = 0;
        for (Connection connection : Connection.values()) {
            if (!connection.isPrimary() || !sourceIcon.hasOverlay(connection.getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    private int countSecondaryConnections(IIcon sourceIcon) {
        int cnt = 0;
        for (Connection connection : Connection.values()) {
            if (connection.isPrimary() || !sourceIcon.hasOverlay(connection.getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    private void handleIconOverlay(IIcon icon, Connection connection) {
        Opcode opcode = Opcodes.OPCODES.get(icon.getID());
        if (opcode.getOpcodeOutput() == OpcodeOutput.NONE) {
            return;
        }
        if (opcode.getOpcodeOutput() == OpcodeOutput.SINGLE) {
            boolean has = icon.hasOverlay(connection.getId());
            for (Connection c : Connection.values()) {
                icon.removeOverlay(c.getId());
            }
            if (!has && !icon.hasOverlay(connection.getId())) {
                icon.addOverlay(CONNECTION_ICONS.get((Object)connection));
            }
        } else if (icon.hasOverlay(connection.getId())) {
            icon.removeOverlay(Connection.DOWN_NEG.getId());
            icon.removeOverlay(Connection.UP_NEG.getId());
            icon.removeOverlay(Connection.LEFT_NEG.getId());
            icon.removeOverlay(Connection.RIGHT_NEG.getId());
            icon.removeOverlay(connection.getId());
            icon.addOverlay(CONNECTION_ICONS.get((Object)connection.getOpposite()));
        } else if (icon.hasOverlay(connection.getOpposite().getId())) {
            icon.removeOverlay(connection.getOpposite().getId());
        } else {
            if (connection.isPrimary()) {
                icon.removeOverlay(Connection.DOWN.getId());
                icon.removeOverlay(Connection.UP.getId());
                icon.removeOverlay(Connection.LEFT.getId());
                icon.removeOverlay(Connection.RIGHT.getId());
            } else {
                icon.removeOverlay(Connection.DOWN_NEG.getId());
                icon.removeOverlay(Connection.UP_NEG.getId());
                icon.removeOverlay(Connection.LEFT_NEG.getId());
                icon.removeOverlay(Connection.RIGHT_NEG.getId());
            }
            icon.addOverlay(CONNECTION_ICONS.get((Object)connection));
        }
    }

    private void clearGrid(boolean selection) {
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 10; ++y) {
                IconHolder h = this.getHolder(x, y);
                if (selection && (h.getIcon() == null || !h.getIcon().hasOverlay("S"))) continue;
                h.setIcon(null);
            }
        }
    }

    private IconHolder getHolder(int x, int y) {
        Panel row = (Panel)this.gridList.getChild(y);
        return (IconHolder)row.getChild(x);
    }

    private void validateAndHilight() {
        ProgramCardInstance instance = this.makeGridInstance(false);
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 10; ++y) {
                IconHolder h = this.getHolder(x, y);
                if (h.getIcon() == null) continue;
                h.getIcon().removeOverlay("E1");
                h.getIcon().removeOverlay("E2");
            }
        }
        long time = System.currentTimeMillis();
        List<Pair<GridPos, String>> errors = ProgramValidator.validate(instance);
        for (Pair<GridPos, String> entry : errors) {
            GridPos p = (GridPos)entry.getKey();
            IconHolder h = this.getHolder(p.getX(), p.getY());
            h.getIcon().addOverlay(time % 2000L < 1000L ? errorIcon1 : errorIcon2);
        }
    }

    private void validateProgram() {
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setFilledBackground(-10066330, -5592406)).setFilledRectThickness(1);
        panel.setBounds(new Rectangle(60, 10, 200, 130));
        final Window modalWindow = this.getWindowManager().createModalWindow((AbstractContainerWidget)panel);
        final WidgetList errorList = new WidgetList(this.field_146297_k, (Gui)this);
        errorList.addSelectionEvent(new SelectionEvent(){

            public void select(Widget parent, int index) {
            }

            public void doubleClick(Widget parent, int index) {
                Widget child;
                GridPos pos;
                if (errorList.getSelected() != -1 && (pos = (GridPos)(child = errorList.getChild(errorList.getSelected())).getUserObject()) != null) {
                    GuiProgrammer.this.window.setTextFocus((Widget)GuiProgrammer.this.getHolder(pos.getX(), pos.getY()));
                }
                GuiProgrammer.this.getWindowManager().closeWindow(modalWindow);
            }
        });
        panel.addChild((Widget)errorList);
        panel.addChild((Widget)new Button(this.field_146297_k, (Gui)this).addButtonEvent(w -> this.getWindowManager().closeWindow(modalWindow)).setText("Close"));
        ProgramCardInstance instance = this.makeGridInstance(false);
        List<Pair<GridPos, String>> errors = ProgramValidator.validate(instance);
        for (Pair<GridPos, String> entry : errors) {
            GridPos p = (GridPos)entry.getKey();
            errorList.addChild((Widget)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(-65536)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText((String)entry.getValue())).setUserObject((Object)p));
        }
    }

    private void askNameAndSave(int slot) {
        ItemStack card = ((ProgrammerTileEntity)this.tileEntity).func_70301_a(slot);
        if (card.func_190926_b()) {
            GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, "No card!");
            return;
        }
        String cardName = ProgramCardItem.getCardName(card);
        if (cardName.isEmpty() || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            GuiTools.askSomething(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, "Card name:", cardName, s -> this.saveProgram(slot, (String)s));
        } else {
            this.saveProgram(slot, cardName);
        }
    }

    private void saveProgram(int slot, String name) {
        ItemStack card = ((ProgrammerTileEntity)this.tileEntity).func_70301_a(slot);
        if (card.func_190926_b()) {
            return;
        }
        if (name != null) {
            ProgramCardItem.setCardName(card, name);
        }
        ProgramCardInstance instance = this.makeGridInstance(false);
        instance.writeToNBT(card);
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemInventoryProgrammer(((ProgrammerTileEntity)this.tileEntity).func_174877_v(), slot, card.func_77978_p()));
    }

    private ProgramCardInstance makeGridInstance(boolean selectionOnly) {
        ProgramCardInstance instance = ProgramCardInstance.newInstance();
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 10; ++y) {
                IconHolder holder = this.getHolder(x, y);
                IIcon icon = holder.getIcon();
                if (icon == null || selectionOnly && !icon.hasOverlay("S")) continue;
                String operandId = icon.getID();
                GridInstance.Builder builder = GridInstance.builder(operandId);
                for (Connection connection : Connection.values()) {
                    if (!icon.hasOverlay(connection.getId())) continue;
                    if (connection.isPrimary()) {
                        builder.primaryConnection(connection);
                        continue;
                    }
                    builder.secondaryConnection(connection);
                }
                Opcode opcode = Opcodes.OPCODES.get(operandId);
                Map data = icon.getData();
                for (ParameterDescription description : opcode.getParameters()) {
                    ParameterValue value;
                    ParameterValue parameterValue = value = data == null ? null : (ParameterValue)data.get(description.getName());
                    if (value == null) {
                        value = ParameterValue.constant(null);
                    }
                    Parameter parameter = Parameter.builder().type(description.getType()).value(value).build();
                    builder.parameter(parameter);
                }
                instance.putGridInstance(x, y, builder.build());
            }
        }
        return instance;
    }

    private void clearProgram() {
        undoProgram = this.makeGridInstance(false);
        this.clearGrid(false);
    }

    private void loadProgram(int slot) {
        ItemStack card = ((ProgrammerTileEntity)this.tileEntity).func_70301_a(slot);
        if (card.func_190926_b()) {
            return;
        }
        this.clearGrid(false);
        ProgramCardInstance instance = ProgramCardInstance.parseInstance(card);
        if (instance == null) {
            return;
        }
        this.loadProgram(instance);
    }

    private GridPos getSelectedGridHolder() {
        IconHolder holder;
        if (this.window.getTextFocus() instanceof IconHolder && (holder = (IconHolder)this.window.getTextFocus()).getUserObject() instanceof GridPos) {
            return (GridPos)holder.getUserObject();
        }
        return null;
    }

    private void mergeProgram(ProgramCardInstance instance, GridPos pos) {
        int y;
        int x;
        int posy;
        int posx;
        GridPos leftTop = new GridPos(10000, 10000);
        if (pos == null) {
            posx = 0;
            posy = 0;
            leftTop = new GridPos(0, 0);
        } else {
            posx = pos.getX();
            posy = pos.getY();
            for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
                x = entry.getKey().getX();
                y = entry.getKey().getY();
                if (x < leftTop.getX()) {
                    leftTop = entry.getKey();
                    continue;
                }
                if (x != leftTop.getX() || y >= leftTop.getY()) continue;
                leftTop = entry.getKey();
            }
            if (leftTop.getX() > 1000) {
                return;
            }
        }
        for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
            x = entry.getKey().getX() - leftTop.getX() + posx;
            if (!this.checkValidGridPos(new GridPos(x, y = entry.getKey().getY() - leftTop.getY() + posy))) {
                GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "No room for clipboard here!");
                return;
            }
            if (this.getHolder(x, y).getIcon() == null) continue;
            GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "No room for clipboard here!");
            return;
        }
        for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
            x = entry.getKey().getX() - leftTop.getX() + posx;
            y = entry.getKey().getY() - leftTop.getY() + posy;
            this.loadGridInstance(entry, x, y);
        }
    }

    private void loadProgram(ProgramCardInstance instance) {
        for (Map.Entry<GridPos, GridInstance> entry : instance.getGridInstances().entrySet()) {
            int x = entry.getKey().getX();
            int y = entry.getKey().getY();
            this.loadGridInstance(entry, x, y);
        }
    }

    private void loadGridInstance(Map.Entry<GridPos, GridInstance> entry, int x, int y) {
        GridInstance gridInstance = entry.getValue();
        IIcon icon = ICONS.get(gridInstance.getId());
        if (icon == null) {
            Logging.logError((String)("Opcode with id '" + gridInstance.getId() + "' is missing!"));
            return;
        }
        icon = icon.clone();
        if (gridInstance.getPrimaryConnection() != null) {
            icon.addOverlay(CONNECTION_ICONS.get((Object)gridInstance.getPrimaryConnection()));
        }
        if (gridInstance.getSecondaryConnection() != null) {
            icon.addOverlay(CONNECTION_ICONS.get((Object)gridInstance.getSecondaryConnection()));
        }
        Opcode opcode = Opcodes.OPCODES.get(icon.getID());
        List<Parameter> parameters = gridInstance.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String name = opcode.getParameters().get(i).getName();
            icon.addData(name, (Object)parameters.get(i).getParameterValue());
        }
        this.loading = true;
        this.getHolder(x, y).setIcon(icon);
        this.loading = false;
    }

    private Panel setupControlPanel() {
        this.trashcan = ((IconHolder)((IconHolder)((IconHolder)new IconHolder(this.field_146297_k, (Gui)this).setDesiredWidth(14)).setDesiredHeight(14)).setBorder(1).setBorderColor(Integer.valueOf(-65536)).setTooltips(new String[]{TextFormatting.YELLOW + "Delete opcode", "Drop opcodes here to", "delete them"})).setSelectable(false);
        return (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(2)).setHorizontalMargin(1)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(108, 136, 145, 18))).addChild((Widget)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Load")).setTooltips(new String[]{TextFormatting.YELLOW + "Load program", "Load the current program", "from a program card"})).setDesiredHeight(15)).addButtonEvent(w -> this.loadProgram(0)))).addChild((Widget)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Save")).setTooltips(new String[]{TextFormatting.YELLOW + "Save program", "Save the current program", "to a program card", TextFormatting.GREEN + "Press shift to change name"})).setDesiredHeight(15)).addButtonEvent(w -> this.askNameAndSave(0)))).addChild((Widget)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Clear")).setTooltips(new String[]{TextFormatting.YELLOW + "Clear program", "Remove all opcodes on the grid", "(press Ctrl-Z if this was a mistake)"})).setDesiredHeight(15)).addButtonEvent(w -> this.clearProgram()))).addChild((Widget)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Val")).setTooltips(new String[]{TextFormatting.YELLOW + "Validate program", "Perform some basic validations on", "the current program", "Double click on error", "to highlight opcode"})).setDesiredHeight(15)).addButtonEvent(w -> this.validateProgram()))).addChild((Widget)this.trashcan);
    }

    private void clearCategoryLabels() {
        for (ImageChoiceLabel label : this.categoryLabels) {
            label.setCurrentChoice("off");
        }
        this.currentCategory = null;
        this.fillOpcodes();
    }

    private void makeCategoryToggle(Panel panel, int cx, int cy, OpcodeCategory category, int u, int v) {
        ImageChoiceLabel catLabel = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(cx * 18 + 3, cy * 18 + 14, 16, 16))).addChoice("off", "Filter on category " + category.getName() + " (off)", guiElements, u * 16, v * 16).addChoice("on", "Filter on category " + category.getName() + " (on)", guiElements, u * 16 + 16, v * 16);
        catLabel.addChoiceEvent((parent, newChoice) -> {
            if ("on".equals(newChoice)) {
                this.clearCategoryLabels();
                catLabel.setCurrentChoice("on");
                this.currentCategory = category;
                this.fillOpcodes();
            } else {
                this.clearCategoryLabels();
            }
        });
        panel.addChild((Widget)catLabel);
        this.categoryLabels.add(catLabel);
    }

    private Panel setupListPanel() {
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(2, 2, 78, 232))).addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText("Opcodes:")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 70, 12)));
        this.makeCategoryToggle(panel, 0, 0, OpcodeCategory.CATEGORY_ITEMS, 8, 5);
        this.makeCategoryToggle(panel, 1, 0, OpcodeCategory.CATEGORY_LIQUIDS, 10, 5);
        this.makeCategoryToggle(panel, 2, 0, OpcodeCategory.CATEGORY_CRAFTING, 6, 5);
        this.makeCategoryToggle(panel, 3, 0, OpcodeCategory.CATEGORY_REDSTONE, 14, 5);
        this.makeCategoryToggle(panel, 0, 1, OpcodeCategory.CATEGORY_ENERGY, 12, 5);
        this.makeCategoryToggle(panel, 1, 1, OpcodeCategory.CATEGORY_NUMBERS, 8, 6);
        this.makeCategoryToggle(panel, 2, 1, OpcodeCategory.CATEGORY_VECTORS, 10, 6);
        this.makeCategoryToggle(panel, 3, 1, OpcodeCategory.CATEGORY_GRAPHICS, 6, 6);
        this.opcodeList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("opcodes")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 52, 68, 180))).setPropagateEventsToChildren(true).setInvisibleSelection(true).setDrawHorizontalLines(false).setRowheight(ICONSIZE + 2);
        Slider slider = (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollableName("opcodes").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(68, 52, 8, 180));
        this.fillOpcodes();
        return (Panel)((Panel)panel.addChild((Widget)this.opcodeList)).addChild((Widget)slider);
    }

    private void fillOpcodes() {
        this.opcodeList.removeChildren();
        int x = 0;
        int y = 0;
        Panel childPanel = null;
        for (Opcode opcode : Opcodes.SORTED_OPCODES) {
            if (this.currentCategory != null && !opcode.getCategories().contains((Object)this.currentCategory)) continue;
            String key = opcode.getId();
            if (childPanel == null) {
                childPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)((HorizontalLayout)new HorizontalLayout().setVerticalMargin(1)).setSpacing(1)).setHorizontalMargin(0)).setDesiredHeight(ICONSIZE + 1);
                this.opcodeList.addChild((Widget)childPanel);
            }
            IconHolder holder = ((IconHolder)((IconHolder)new IconHolder(this.field_146297_k, (Gui)this){

                public List<String> getTooltips() {
                    return GuiProgrammer.this.getIconTooltip(this.getIcon());
                }
            }.setDesiredWidth(ICONSIZE)).setDesiredHeight(ICONSIZE)).setMakeCopy(true);
            holder.setIcon(ICONS.get(key).clone());
            childPanel.addChild((Widget)holder);
            if (++x < 3) continue;
            ++y;
            x = 0;
            childPanel = null;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.handleClipboard(keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void keyTypedFromEvent(char typedChar, int keyCode) {
        if (this.handleClipboard(keyCode)) {
            return;
        }
        super.keyTypedFromEvent(typedChar, keyCode);
    }

    private boolean handleClipboard(int keyCode) {
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            if (keyCode == 30) {
                this.selectAll();
            } else {
                if (keyCode == 46) {
                    if (!this.checkSelection()) {
                        GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Nothing is selected!");
                    } else {
                        ProgramCardInstance instance = this.makeGridInstance(true);
                        String json = instance.writeToJson();
                        try {
                            StringSelection selection = new StringSelection(json);
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(selection, selection);
                        }
                        catch (Exception e) {
                            GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error copying to clipboard!");
                        }
                    }
                    return true;
                }
                if (keyCode == 44) {
                    if (undoProgram != null) {
                        ProgramCardInstance curProgram = this.makeGridInstance(false);
                        this.clearGrid(false);
                        this.loadProgram(undoProgram);
                        undoProgram = curProgram;
                    }
                    return true;
                }
                if (keyCode == 45) {
                    if (!this.checkSelection()) {
                        GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Nothing is selected!");
                    } else {
                        ProgramCardInstance instance = this.makeGridInstance(true);
                        String json = instance.writeToJson();
                        try {
                            StringSelection selection = new StringSelection(json);
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(selection, selection);
                            undoProgram = this.makeGridInstance(false);
                            this.clearGrid(this.checkSelection());
                        }
                        catch (Exception e) {
                            GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error copying to clipboard!");
                        }
                    }
                    return true;
                }
                if (keyCode == 47) {
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        String data = (String)clipboard.getData(DataFlavor.stringFlavor);
                        ProgramCardInstance program = ProgramCardInstance.readFromJson(data);
                        undoProgram = this.makeGridInstance(false);
                        this.mergeProgram(program, this.getSelectedGridHolder());
                    }
                    catch (UnsupportedFlavorException e) {
                        GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Clipboard does not contain program!");
                    }
                    catch (Exception e) {
                        GuiTools.showMessage(this.field_146297_k, (Gui)this, this.getWindowManager(), 50, 50, TextFormatting.RED + "Error reading from clipboard!");
                    }
                }
            }
        }
        return false;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotId == -999) {
            return;
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    private List<String> getIconTooltipGrid(int x, int y) {
        IconHolder holder = this.getHolder(x, y);
        IIcon icon = holder.getIcon();
        if (icon != null) {
            Opcode opcode = Opcodes.OPCODES.get(icon.getID());
            List<String> description = opcode.getDescription();
            ArrayList<String> tooltips = new ArrayList<String>();
            boolean isComment = Opcodes.DO_COMMENT.getId().equals(opcode.getId());
            if (isComment) {
                Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
                for (ParameterDescription parameter : opcode.getParameters()) {
                    String s;
                    String name = parameter.getName();
                    ParameterValue value = (ParameterValue)data.get(name);
                    if (value == null || (s = ParameterTypeTools.stringRepresentation(parameter.getType(), value)).isEmpty()) continue;
                    tooltips.add(TextFormatting.BLUE + s);
                }
            } else if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                tooltips.add(description.get(0) + TextFormatting.WHITE + " [" + x + "," + y + "]");
                Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
                for (ParameterDescription parameter : opcode.getParameters()) {
                    String name = parameter.getName();
                    ParameterValue value = (ParameterValue)data.get(name);
                    if (value != null) {
                        tooltips.add(TextFormatting.BLUE + "Par " + name + ": " + ParameterTypeTools.stringRepresentation(parameter.getType(), value));
                        continue;
                    }
                    tooltips.add(TextFormatting.BLUE + "Par " + name + ": NULL");
                }
            } else {
                tooltips.add(description.get(0));
                tooltips.add("<Shift for more info>");
            }
            return tooltips;
        }
        return Collections.emptyList();
    }

    private List<String> getIconTooltip(IIcon icon) {
        if (icon != null) {
            Opcode opcode = Opcodes.OPCODES.get(icon.getID());
            List<String> description = opcode.getDescription();
            ArrayList<String> tooltips = new ArrayList<String>();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                tooltips.addAll(description);
                for (ParameterDescription parameter : opcode.getParameters()) {
                    boolean first = true;
                    for (int i = 0; i < parameter.getDescription().size(); ++i) {
                        String s = parameter.getDescription().get(i);
                        if (first) {
                            s = TextFormatting.BLUE + "Par '" + parameter.getName() + "': " + s;
                            first = false;
                        } else {
                            s = TextFormatting.BLUE + "      " + s;
                        }
                        if (parameter.isOptional() && i == parameter.getDescription().size() - 1) {
                            s = s + TextFormatting.GOLD + " [Optional]";
                        }
                        tooltips.add(s);
                    }
                }
                tooltips.add(TextFormatting.YELLOW + "Result: " + opcode.getOutputDescription());
            } else {
                tooltips.add(description.get(0));
                tooltips.add("<Shift for more info>");
            }
            return tooltips;
        }
        return Collections.emptyList();
    }

    private void selectIcon(Window parent, Widget<?> focused) {
        if (parent == this.window && focused instanceof IconHolder) {
            this.clearEditorPanel();
            IconHolder iconHolder = (IconHolder)focused;
            IIcon icon = iconHolder.getIcon();
            if (icon != null) {
                this.setEditorPanel(iconHolder, icon);
            }
        }
    }

    private Panel createValuePanel(ParameterDescription parameter, IIcon icon, IconHolder iconHolder, String tempDefault, boolean constantOnly) {
        Label label = (Label)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(StringUtils.capitalize((String)parameter.getName()) + ":")).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredHeight(13)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 53, 13));
        ArrayList<String> description = new ArrayList<String>(parameter.getDescription());
        if (parameter.isOptional()) {
            description.set(description.size() - 1, (String)description.get(description.size() - 1) + TextFormatting.GOLD + " [Optional]");
        }
        if (tempDefault != null && !tempDefault.isEmpty()) {
            description.add(TextFormatting.BLUE + tempDefault);
        }
        String[] tooltips = description.toArray(new String[description.size()]);
        TextField field = (TextField)((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setText(tempDefault).setTooltips(tooltips)).setDesiredHeight(13)).setEditable(false).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 12, 68, 13));
        Button button = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("...")).setDesiredHeight(13)).setTooltips(tooltips)).addButtonEvent(w -> this.openValueEditor(icon, iconHolder, parameter, field, constantOnly)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(58, 0, 11, 13));
        return (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).addChild((Widget)label)).addChild((Widget)field)).addChild((Widget)button)).setDesiredWidth(68);
    }

    private void openValueEditor(IIcon icon, IconHolder iconHolder, ParameterDescription parameter, TextField field, boolean constantOnly) {
        Panel editPanel;
        ParameterEditor editor = ParameterEditors.getEditor(parameter.getType());
        if (editor != null) {
            editPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(1);
            Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
            editor.build(this.field_146297_k, (Gui)this, editPanel, o -> {
                icon.addData(parameter.getName(), (Object)o);
                field.setText(ParameterTypeTools.stringRepresentation(parameter.getType(), o));
            });
            editor.writeValue((ParameterValue)data.get(parameter.getName()));
            if (constantOnly) {
                editor.constantOnly();
            }
        } else {
            return;
        }
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setFilledBackground(-10066330, -5592406)).setFilledRectThickness(1);
        panel.setBounds(new Rectangle(50, 25, 200, 60 + editor.getHeight()));
        Window modalWindow = this.getWindowManager().createModalWindow((AbstractContainerWidget)panel);
        panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(StringUtils.capitalize((String)parameter.getName()) + ":"));
        panel.addChild((Widget)editPanel);
        panel.addChild((Widget)new Button(this.field_146297_k, (Gui)this).addButtonEvent(w -> {
            this.getWindowManager().closeWindow(modalWindow);
            this.window.setTextFocus((Widget)iconHolder);
        }).setText("Close"));
        editor.initialFocus(modalWindow);
        editor.setOnClose(() -> this.window.setTextFocus((Widget)iconHolder));
    }

    private void clearEditorPanel() {
        this.editorList.removeChildren();
    }

    private void setEditorPanel(IconHolder iconHolder, IIcon icon) {
        String id = icon.getID();
        Opcode opcode = Opcodes.OPCODES.get(id);
        Map data = icon.getData() == null ? Collections.emptyMap() : icon.getData();
        this.clearEditorPanel();
        for (ParameterDescription parameter : opcode.getParameters()) {
            String name = parameter.getName();
            ParameterValue value = (ParameterValue)data.get(name);
            Panel panel = value != null ? this.createValuePanel(parameter, icon, iconHolder, ParameterTypeTools.stringRepresentation(parameter.getType(), value), opcode.isEvent()) : this.createValuePanel(parameter, icon, iconHolder, "", opcode.isEvent());
            this.editorList.addChild((Widget)panel);
        }
    }

    private Panel setupEditorPanel() {
        this.editorList = (WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("editor")).setPropagateEventsToChildren(true).setRowheight(30).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(0, 0, 75, 96));
        Slider slider = (Slider)new Slider(this.field_146297_k, (Gui)this).setScrollableName("editor").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(76, 0, 9, 96));
        return (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 137, 85, 96))).setFilledRectThickness(-1)).setFilledBackground(StyleConfig.colorListBackground)).addChild((Widget)this.editorList)).addChild((Widget)slider);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawWindow();
        this.trashcan.setIcon(null);
        --this.saveCounter;
        if (this.saveCounter < 0) {
            this.saveCounter = 10;
            this.validateAndHilight();
            this.saveProgram(1, null);
        }
    }

    static {
        undoProgram = null;
        CONNECTION_ICONS.put(Connection.UP, (IIcon)new ImageIcon(Connection.UP.getId()).setImage(icons, 0 * ICONSIZE, 5 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.UP_NEG, (IIcon)new ImageIcon(Connection.UP_NEG.getId()).setImage(icons, 0 * ICONSIZE, 6 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.RIGHT, (IIcon)new ImageIcon(Connection.RIGHT.getId()).setImage(icons, 1 * ICONSIZE, 5 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.RIGHT_NEG, (IIcon)new ImageIcon(Connection.RIGHT_NEG.getId()).setImage(icons, 1 * ICONSIZE, 6 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.DOWN, (IIcon)new ImageIcon(Connection.DOWN.getId()).setImage(icons, 2 * ICONSIZE, 5 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.DOWN_NEG, (IIcon)new ImageIcon(Connection.DOWN_NEG.getId()).setImage(icons, 2 * ICONSIZE, 6 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.LEFT, (IIcon)new ImageIcon(Connection.LEFT.getId()).setImage(icons, 3 * ICONSIZE, 5 * ICONSIZE));
        CONNECTION_ICONS.put(Connection.LEFT_NEG, (IIcon)new ImageIcon(Connection.LEFT_NEG.getId()).setImage(icons, 3 * ICONSIZE, 6 * ICONSIZE));
        HIGHLIGHT_ICONS.put(Connection.UP, (IIcon)new ImageIcon("H").setImage(icons, 0 * ICONSIZE, 7 * ICONSIZE));
        HIGHLIGHT_ICONS.put(Connection.RIGHT, (IIcon)new ImageIcon("H").setImage(icons, 1 * ICONSIZE, 7 * ICONSIZE));
        HIGHLIGHT_ICONS.put(Connection.DOWN, (IIcon)new ImageIcon("H").setImage(icons, 2 * ICONSIZE, 7 * ICONSIZE));
        HIGHLIGHT_ICONS.put(Connection.LEFT, (IIcon)new ImageIcon("H").setImage(icons, 3 * ICONSIZE, 7 * ICONSIZE));
        for (IIcon icon : CONNECTION_ICONS.values()) {
            ((ImageIcon)icon).setDimensions(ICONSIZE, ICONSIZE);
        }
        for (IIcon icon : HIGHLIGHT_ICONS.values()) {
            ((ImageIcon)icon).setDimensions(ICONSIZE, ICONSIZE);
        }
        selectionIcon = new ImageIcon("S").setDimensions(ICONSIZE, ICONSIZE).setImage(icons, 0 * ICONSIZE, 8 * ICONSIZE);
        errorIcon1 = new ImageIcon("E1").setDimensions(ICONSIZE, ICONSIZE).setImage(icons, 1 * ICONSIZE, 8 * ICONSIZE);
        errorIcon2 = new ImageIcon("E2").setDimensions(ICONSIZE, ICONSIZE).setImage(icons, 2 * ICONSIZE, 8 * ICONSIZE);
    }
}

