/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix.bugs.mixins.client;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenshotEvent;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft
implements IThreadListener,
ISnooperInfo {
    @Shadow
    @Final
    private static Logger field_147123_G;
    @Shadow
    @Final
    public Profiler field_71424_I;
    @Shadow
    public GuiIngame field_71456_v;

    @Redirect(method={"runTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;endStartSection(Ljava/lang/String;)V", ordinal=0))
    private void endStartGUISection(Profiler profiler, String name) {
        profiler.func_76318_c("gui");
    }

    @Redirect(method={"runTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureManager;tick()V", ordinal=0))
    private void tickTextureManagerWithCorrectProfiler(TextureManager textureManager) {
        this.field_71424_I.func_76318_c("textures");
        textureManager.func_110550_d();
        this.field_71424_I.func_76318_c("gui");
    }

    @Redirect(method={"dispatchKeypresses"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/ScreenShotHelper;saveScreenshot(Ljava/io/File;IILnet/minecraft/client/shader/Framebuffer;)Lnet/minecraft/util/text/ITextComponent;", ordinal=0))
    private ITextComponent saveScreenshotAsync(File gameDirectory, int width, int height, Framebuffer buffer) {
        try {
            BufferedImage screenshot = ScreenShotHelper.func_186719_a((int)width, (int)height, (Framebuffer)buffer);
            new Thread(() -> {
                try {
                    File screenshotDir = new File(gameDirectory, "screenshots");
                    screenshotDir.mkdir();
                    File screenshotFile = ScreenShotHelper.func_74290_a((File)screenshotDir).getCanonicalFile();
                    ScreenshotEvent event = ForgeHooksClient.onScreenshot((BufferedImage)screenshot, (File)screenshotFile);
                    if (event.isCanceled()) {
                        this.field_71456_v.func_146158_b().func_146227_a(event.getCancelMessage());
                        return;
                    }
                    screenshotFile = event.getScreenshotFile();
                    ImageIO.write((RenderedImage)screenshot, "png", screenshotFile);
                    if (event.getResultMessage() != null) {
                        this.field_71456_v.func_146158_b().func_146227_a(event.getResultMessage());
                        return;
                    }
                    TextComponentString screenshotLink = new TextComponentString(screenshotFile.getName());
                    screenshotLink.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, screenshotFile.getAbsolutePath()));
                    screenshotLink.func_150256_b().func_150228_d(Boolean.valueOf(true));
                    this.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("screenshot.success", new Object[]{screenshotLink}));
                }
                catch (Exception e) {
                    field_147123_G.warn("Couldn't save screenshot", (Throwable)e);
                    this.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("screenshot.failure", new Object[]{e.getMessage()}));
                }
            }, "Screenshot Saving Thread").start();
        }
        catch (Exception e) {
            field_147123_G.warn("Couldn't save screenshot", (Throwable)e);
            this.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("screenshot.failure", new Object[]{e.getMessage()}));
        }
        return null;
    }

    @Redirect(method={"dispatchKeypresses"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiNewChat;printChatMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=0))
    private void sendScreenshotMessage(GuiNewChat guiNewChat, ITextComponent chatComponent) {
    }
}

