/*
 * Decompiled with CFR 0.152.
 */
package ts2k16.blacklist;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import ts2k16.blacklist.BlockEntry;

public class BlockBlacklist {
    public static final BlockBlacklist INSTANCE = new BlockBlacklist();
    private final List<BlockEntry> blacklist = new ArrayList<BlockEntry>();
    private final List<BlockEntry> whitelist = new ArrayList<BlockEntry>();

    public boolean isBlacklisted(IBlockState state) {
        for (BlockEntry entry : this.blacklist) {
            if (!entry.checkMatch(state)) continue;
            return true;
        }
        return false;
    }

    public boolean isWhitelisted(IBlockState state) {
        for (BlockEntry entry : this.whitelist) {
            if (!entry.checkMatch(state)) continue;
            return true;
        }
        return false;
    }

    public void loadBlacklist(String[] list) {
        this.blacklist.clear();
        for (String s : list) {
            BlockEntry entry = BlockEntry.readFromString(s);
            if (entry == null) continue;
            this.blacklist.add(entry);
        }
    }

    public void loadWhitelist(String[] list) {
        this.whitelist.clear();
        for (String s : list) {
            BlockEntry entry = BlockEntry.readFromString(s);
            if (entry == null) continue;
            this.whitelist.add(entry);
        }
    }
}

