/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.util;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MissingMappingsHandler {
    @SubscribeEvent
    public void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.func_110623_a();
            MissingMappingsHandler.replaceOldChestBlock(path, (RegistryEvent.MissingMappings.Mapping<Block>)entry);
        }
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.func_110623_a();
            MissingMappingsHandler.replaceOldChestItem(path, (RegistryEvent.MissingMappings.Mapping<Item>)entry);
            MissingMappingsHandler.replaceOldUpgrades(path, (RegistryEvent.MissingMappings.Mapping<Item>)entry);
            MissingMappingsHandler.replaceNewUpgrades(path, (RegistryEvent.MissingMappings.Mapping<Item>)entry);
        }
    }

    private static void replaceOldChestBlock(String path, RegistryEvent.MissingMappings.Mapping<Block> mapping) {
        if (path.endsWith("blockironchest")) {
            path = path.replace("blockironchest", "iron_chest");
            ResourceLocation newRes = new ResourceLocation(mapping.key.func_110624_b(), path);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(newRes);
            if (block != null) {
                mapping.remap((IForgeRegistryEntry)block);
            }
        }
    }

    private static void replaceOldChestItem(String path, RegistryEvent.MissingMappings.Mapping<Item> mapping) {
        if (path.endsWith("blockironchest")) {
            path = path.replace("blockironchest", "iron_chest");
            ResourceLocation newRes = new ResourceLocation(mapping.key.func_110624_b(), path);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(newRes);
            if (item != null) {
                mapping.remap((IForgeRegistryEntry)item);
            }
        }
    }

    private static void replaceOldUpgrades(String path, RegistryEvent.MissingMappings.Mapping<Item> mapping) {
        if (path.endsWith("irongoldupgrade")) {
            path = path.replace("irongoldupgrade", "iron_gold_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("golddiamondupgrade")) {
            path = path.replace("golddiamondupgrade", "gold_diamond_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("coppersilverupgrade")) {
            path = path.replace("coppersilverupgrade", "copper_silver_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("silvergoldupgrade")) {
            path = path.replace("silvergoldupgrade", "silver_gold_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("copperironupgrade")) {
            path = path.replace("copperironupgrade", "copper_iron_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("diamondcrystalupgrade")) {
            path = path.replace("diamondcrystalupgrade", "diamond_crystal_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("woodironupgrade")) {
            path = path.replace("woodironupgrade", "wood_iron_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("woodcopperupgrade")) {
            path = path.replace("woodcopperupgrade", "wood_copper_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("diamondobsidianupgrade")) {
            path = path.replace("diamondobsidianupgrade", "diamond_obsidian_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
    }

    private static void replaceNewUpgrades(String path, RegistryEvent.MissingMappings.Mapping<Item> mapping) {
        if (path.endsWith("iron_gold_upgrade")) {
            path = path.replace("iron_gold_upgrade", "iron_gold_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("gold_diamond_upgrade")) {
            path = path.replace("gold_diamond_upgrade", "gold_diamond_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("copper_silver_upgrade")) {
            path = path.replace("copper_silver_upgrade", "copper_silver_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("silver_gold_upgrade")) {
            path = path.replace("silver_gold_upgrade", "silver_gold_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("copper_iron_upgrade")) {
            path = path.replace("copper_iron_upgrade", "copper_iron_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("diamond_crystal_upgrade")) {
            path = path.replace("diamond_crystal_upgrade", "diamond_crystal_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("wood_iron_upgrade")) {
            path = path.replace("wood_iron_upgrade", "wood_iron_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("wood_copper_upgrade")) {
            path = path.replace("wood_copper_upgrade", "wood_copper_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
        if (path.endsWith("diamond_obsidian_upgrade")) {
            path = path.replace("diamond_obsidian_upgrade", "diamond_obsidian_chest_upgrade");
            MissingMappingsHandler.replaceUpgradeItem(path, mapping);
        }
    }

    private static void replaceUpgradeItem(String path, RegistryEvent.MissingMappings.Mapping<Item> mapping) {
        ResourceLocation newRes = new ResourceLocation(mapping.key.func_110624_b(), path);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(newRes);
        if (item != null) {
            mapping.remap((IForgeRegistryEntry)item);
        }
    }
}

