/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stonechest;

import ftblag.stonechest.blocks.BlockStoneChest;
import ftblag.stonechest.blocks.EnumStoneChest;
import ftblag.stonechest.client.TEISRChest;
import ftblag.stonechest.client.TileEntityStoneChestRenderer;
import ftblag.stonechest.items.ItemChestPart;
import ftblag.stonechest.tileentities.TileEntityStoneChest;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="stonechest", name="Stone Chest", version="1.0.4", acceptedMinecraftVersions="[1.12.2]")
public class StoneChest {
    public static final String MODID = "stonechest";
    public static final String NAME = "Stone Chest";
    public static ItemChestPart[] parts = new ItemChestPart[EnumStoneChest.values().length];
    public static BlockStoneChest[] chests = new BlockStoneChest[EnumStoneChest.values().length];

    private static ItemStack getBlock(EnumStoneChest type) {
        switch (type) {
            case STONE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.STONE.func_176642_a());
            }
            case GRANITE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.GRANITE.func_176642_a());
            }
            case DIORITE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.DIORITE.func_176642_a());
            }
            case ANDESITE: {
                return new ItemStack(Blocks.field_150348_b, 1, BlockStone.EnumType.ANDESITE.func_176642_a());
            }
        }
        return new ItemStack(Blocks.field_150347_e);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        GameRegistry.registerTileEntity(TileEntityStoneChest.class, (String)"stonechest:chest");
        for (EnumStoneChest type : EnumStoneChest.values()) {
            String partName = "part_" + type.name().toLowerCase();
            ItemChestPart part = new ItemChestPart(partName);
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("stonechest:" + partName), null, (ItemStack)new ItemStack((Item)part), (Object[])new Object[]{"# ", " #", Character.valueOf('#'), StoneChest.getBlock(type)});
            StoneChest.parts[type.ordinal()] = part;
            String chestName = "chest_" + type.name().toLowerCase();
            BlockStoneChest chest = new BlockStoneChest(type, chestName);
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)chest);
            ForgeRegistries.ITEMS.registerAll((IForgeRegistryEntry[])new Item[]{part, (Item)new ItemBlock((Block)chest){

                public int getItemBurnTime(ItemStack itemStack) {
                    return 0;
                }
            }.setRegistryName(chest.getRegistryName())});
            OreDictionary.registerOre((String)"chest", (Block)chest);
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("stonechest:" + chestName), null, (ItemStack)new ItemStack((Block)chest), (Object[])new Object[]{"##", "##", Character.valueOf('#'), part});
            StoneChest.chests[type.ordinal()] = chest;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.preInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void preInit() {
        TEISRChest TEISR = new TEISRChest();
        for (BlockStoneChest blockStoneChest : chests) {
            Item item = Item.func_150898_a((Block)blockStoneChest);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(blockStoneChest.getRegistryName(), "inventory"));
            item.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)TEISR);
        }
        for (ItemChestPart itemChestPart : parts) {
            ModelLoader.setCustomModelResourceLocation((Item)itemChestPart, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemChestPart.getRegistryName(), "inventory"));
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStoneChest.class, (TileEntitySpecialRenderer)new TileEntityStoneChestRenderer());
    }
}

