/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stonechest.blocks;

import ftblag.stonechest.blocks.EnumStoneChest;
import ftblag.stonechest.tileentities.TileEntityStoneChest;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class BlockStoneChest
extends BlockChest {
    public static final BlockChest.Type TYPE_STONE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"STONE", (Class[])new Class[0], (Object[])new Object[0]);
    public EnumStoneChest type;

    public BlockStoneChest(EnumStoneChest type, String name) {
        super(TYPE_STONE);
        this.type = type;
        this.func_149663_c(name);
        this.setRegistryName("stonechest", name);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isType(this.type, source, pos.func_177978_c()) ? field_185557_b : (this.isType(this.type, source, pos.func_177968_d()) ? field_185558_c : (this.isType(this.type, source, pos.func_177976_e()) ? field_185559_d : (this.isType(this.type, source, pos.func_177974_f()) ? field_185560_e : field_185561_f)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_176455_e(worldIn, pos, state);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) continue;
            this.func_176455_e(worldIn, blockpos, iblockstate);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176459_a, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)field_176459_a, (Comparable)enumfacing);
        BlockPos northBP = pos.func_177978_c();
        BlockPos southBP = pos.func_177968_d();
        BlockPos westBP = pos.func_177976_e();
        BlockPos eastBP = pos.func_177974_f();
        boolean flagN = this.isType(this.type, (IBlockAccess)worldIn, northBP);
        boolean flagS = this.isType(this.type, (IBlockAccess)worldIn, southBP);
        boolean flagW = this.isType(this.type, (IBlockAccess)worldIn, westBP);
        boolean flagE = this.isType(this.type, (IBlockAccess)worldIn, eastBP);
        if (!(flagN || flagS || flagW || flagE)) {
            worldIn.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() != EnumFacing.Axis.X || !flagN && !flagS) {
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Z && (flagW || flagE)) {
                if (flagW) {
                    this.setBlockState(worldIn, westBP, state, 3);
                } else {
                    this.setBlockState(worldIn, eastBP, state, 3);
                }
                worldIn.func_180501_a(pos, state, 3);
            }
        } else {
            if (flagN) {
                this.setBlockState(worldIn, northBP, state, 3);
            } else {
                this.setBlockState(worldIn, southBP, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        }
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityStoneChest) {
            ((TileEntityStoneChest)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    private void setBlockState(World world, BlockPos pos, IBlockState state, int flag) {
        TileEntity te = world.func_175625_s(pos);
        world.func_180501_a(pos, state, flag);
        if (te != null) {
            te.func_145829_t();
            world.func_175690_a(pos, te);
            if (te instanceof TileEntityStoneChest) {
                ((TileEntityStoneChest)te).field_145984_a = false;
            }
        }
    }

    public IBlockState func_176455_e(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            return state;
        }
        boolean northSame = this.isType(this.type, (IBlockAccess)worldIn, pos.func_177978_c());
        boolean southSame = this.isType(this.type, (IBlockAccess)worldIn, pos.func_177968_d());
        boolean westSame = this.isType(this.type, (IBlockAccess)worldIn, pos.func_177976_e());
        boolean eastSame = this.isType(this.type, (IBlockAccess)worldIn, pos.func_177974_f());
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176459_a);
        if (!northSame && !southSame) {
            boolean flag = iblockstate.func_185913_b();
            boolean flag1 = iblockstate1.func_185913_b();
            if (westSame || eastSame) {
                BlockPos blockpos1 = westSame ? pos.func_177976_e() : pos.func_177974_f();
                IBlockState iblockstate7 = worldIn.func_180495_p(blockpos1.func_177978_c());
                IBlockState iblockstate6 = worldIn.func_180495_p(blockpos1.func_177968_d());
                enumfacing = EnumFacing.SOUTH;
                EnumFacing enumfacing2 = westSame ? (EnumFacing)iblockstate2.func_177229_b((IProperty)field_176459_a) : (EnumFacing)iblockstate3.func_177229_b((IProperty)field_176459_a);
                if (enumfacing2 == EnumFacing.NORTH) {
                    enumfacing = EnumFacing.NORTH;
                }
                if ((flag || iblockstate7.func_185913_b()) && !flag1 && !iblockstate6.func_185913_b()) {
                    enumfacing = EnumFacing.SOUTH;
                }
                if ((flag1 || iblockstate6.func_185913_b()) && !flag && !iblockstate7.func_185913_b()) {
                    enumfacing = EnumFacing.NORTH;
                }
            }
        } else {
            BlockPos blockpos = northSame ? pos.func_177978_c() : pos.func_177968_d();
            IBlockState iblockstate4 = worldIn.func_180495_p(blockpos.func_177976_e());
            IBlockState iblockstate5 = worldIn.func_180495_p(blockpos.func_177974_f());
            enumfacing = EnumFacing.EAST;
            EnumFacing enumfacing1 = northSame ? (EnumFacing)iblockstate.func_177229_b((IProperty)field_176459_a) : (EnumFacing)iblockstate1.func_177229_b((IProperty)field_176459_a);
            if (enumfacing1 == EnumFacing.WEST) {
                enumfacing = EnumFacing.WEST;
            }
            if ((iblockstate2.func_185913_b() || iblockstate4.func_185913_b()) && !iblockstate3.func_185913_b() && !iblockstate5.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            }
            if ((iblockstate3.func_185913_b() || iblockstate5.func_185913_b()) && !iblockstate2.func_185913_b() && !iblockstate4.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
        }
        state = state.func_177226_a((IProperty)field_176459_a, (Comparable)enumfacing);
        this.setBlockState(worldIn, pos, state, 3);
        return state;
    }

    public IBlockState func_176458_f(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = null;
        for (EnumFacing horizontal : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(horizontal));
            if (this.isType(this.type, (IBlockAccess)worldIn, pos.func_177972_a(horizontal))) {
                return state;
            }
            if (!iblockstate.func_185913_b()) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = horizontal;
        }
        if (enumfacing != null) {
            return state.func_177226_a((IProperty)field_176459_a, (Comparable)enumfacing.func_176734_d());
        }
        EnumFacing current = (EnumFacing)state.func_177229_b((IProperty)field_176459_a);
        if (worldIn.func_180495_p(pos.func_177972_a(current)).func_185913_b()) {
            current = current.func_176734_d();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(current)).func_185913_b()) {
            current = current.func_176746_e();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(current)).func_185913_b()) {
            current = current.func_176734_d();
        }
        return state.func_177226_a((IProperty)field_176459_a, (Comparable)current);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        int i = 0;
        BlockPos westBP = pos.func_177976_e();
        BlockPos eastBP = pos.func_177974_f();
        BlockPos northBP = pos.func_177978_c();
        BlockPos southBP = pos.func_177968_d();
        if (this.isType(this.type, (IBlockAccess)worldIn, westBP)) {
            if (this.func_176454_e(worldIn, westBP)) {
                return false;
            }
            ++i;
        }
        if (this.isType(this.type, (IBlockAccess)worldIn, eastBP)) {
            if (this.func_176454_e(worldIn, eastBP)) {
                return false;
            }
            ++i;
        }
        if (this.isType(this.type, (IBlockAccess)worldIn, northBP)) {
            if (this.func_176454_e(worldIn, northBP)) {
                return false;
            }
            ++i;
        }
        if (this.isType(this.type, (IBlockAccess)worldIn, southBP)) {
            if (this.func_176454_e(worldIn, southBP)) {
                return false;
            }
            ++i;
        }
        return i <= 1;
    }

    public boolean func_176454_e(World worldIn, BlockPos pos) {
        if (!this.isType(this.type, (IBlockAccess)worldIn, pos)) {
            return false;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.isType(this.type, (IBlockAccess)worldIn, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityStoneChest();
    }

    public boolean isType(EnumStoneChest type, IBlockAccess source, BlockPos pos) {
        EnumStoneChest other = this.getType(source, pos);
        return other != null && other == type;
    }

    public EnumStoneChest getType(IBlockAccess source, BlockPos pos) {
        if (source.func_180495_p(pos).func_177230_c() == this) {
            return ((BlockStoneChest)source.func_180495_p((BlockPos)pos).func_177230_c()).type;
        }
        return null;
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Nullable
    public ILockableContainer func_189418_a(World worldIn, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityStoneChest)) {
            return null;
        }
        TileEntityStoneChest ilockablecontainer = (TileEntityStoneChest)tileentity;
        if (!allowBlocking && this.isBlocked(worldIn, pos)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            if (!this.isType(this.type, (IBlockAccess)worldIn, blockpos)) continue;
            if (!allowBlocking && this.isBlocked(worldIn, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityStoneChest)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                ilockablecontainer = new InventoryLargeChest("container.chestDouble", (ILockableContainer)ilockablecontainer, (ILockableContainer)((TileEntityStoneChest)tileentity1));
                continue;
            }
            ilockablecontainer = new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityStoneChest)tileentity1), (ILockableContainer)ilockablecontainer);
        }
        return ilockablecontainer;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (Entity entity : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot entityocelot = (EntityOcelot)entity;
            if (!entityocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }
}

