/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stonechest.tileentities;

import ftblag.stonechest.blocks.BlockStoneChest;
import ftblag.stonechest.blocks.EnumStoneChest;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.VanillaDoubleChestItemHandler;

public class TileEntityStoneChest
extends TileEntityChest {
    private EnumStoneChest type;

    public TileEntityStoneChest() {
    }

    public TileEntityStoneChest(EnumStoneChest typeIn) {
        this.type = typeIn;
    }

    @Nullable
    public static VanillaDoubleChestItemHandler getDoubleChestHandler(TileEntityStoneChest chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntityStoneChest otherChest;
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileEntityStoneChest) || !(otherChest = (TileEntityStoneChest)otherTE).getPlacedType().equals((Object)chest.getPlacedType())) continue;
            return new VanillaDoubleChestItemHandler((TileEntityChest)chest, (TileEntityChest)otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE;
    }

    private void setNeighbor(TileEntityChest chestTe, EnumFacing side) {
        if (chestTe.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chestTe) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    @Nullable
    protected TileEntityChest func_174911_a(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (tileentity = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntityStoneChest) {
            TileEntityStoneChest tileentitystonechest = (TileEntityStoneChest)tileentity;
            tileentitystonechest.setNeighbor(this, side.func_176734_d());
            return tileentitystonechest;
        }
        return null;
    }

    private boolean isChestAt(BlockPos posIn) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(posIn).func_177230_c();
        return block instanceof BlockStoneChest && ((BlockStoneChest)block).type == this.getPlacedType();
    }

    public EnumStoneChest getPlacedType() {
        if (this.type == null) {
            if (this.field_145850_b == null || !(this.func_145838_q() instanceof BlockStoneChest)) {
                return EnumStoneChest.COBBLESTONE;
            }
            this.type = ((BlockStoneChest)this.func_145838_q()).type;
        }
        return this.type;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.doubleChestHandler == null || this.doubleChestHandler.needsRefresh()) {
                this.doubleChestHandler = TileEntityStoneChest.getDoubleChestHandler(this);
            }
            if (this.doubleChestHandler != null && this.doubleChestHandler != VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE) {
                return (T)this.doubleChestHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

